/* gpr2rle.c - convert an apollo GPR bitmap to an RLE (Utah Raster Toolkit) file
 *
 * You need the Utah Raster Toolkit library to build this program.
 *
 *                 Version 1.0   12/03/1989
 *
 *  This file contains system-specific graphics routines.
 *  These routines use Apollo Graphics Primitive Resource (GPR) calls.
 *
 *  Authors:   Roque D. Oliveira      oliveria@caen.engin.umich.edu
 *             Amadi Nwankpa             amadi@caen.engin.umich.edu
 *
 *  If you make any improvements/bug fixes to this program, please send
 *  them to the authors.
 */

/*
 * Copyright (C) 1990 by the author(s).
 * All rights reserved.
 *
 * Permission is granted to copy, modify and distribute this program
 * for any purpose and without charge, provided this copyright notice
 * is included in the copy.
 * This program is distributed on an as-is basis. There will be
 * ABSOLUTELY NO WARRANTY for any part of this software to work
 * correctly. In no case will the author(s) be liable to you for any
 * lost revenue or profits or other special, indirect and consequential
 * damages caused by the usage of this program.
 */

#include <stdio.h>
#include <string.h>

#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/pfm.h>
#include <apollo/error.h>
#include "rle.h"                    /* RLE stuff */
#include "rle_put.h"                /* RLE stuff */

#define MAXLINE  4096               /* max width of a line */

char       *progname;
status_$t  status;

void usage()
{
    fprintf(stderr,"usage: %s bitmap_file_name  > rle_file_name \n",progname);
    exit(-1);
}

void check(messagex)
char *messagex;
{
   if (status.all != status_$ok)
     {
         /* error_$print (status); */
         fprintf(stderr,"Error occurred while %s. \n", messagex); 
         pfm_$error_trap(status);
     }    
}

main(argc,argv)
int     argc;
char    *argv[];
{
   gpr_$attribute_desc_t           attribs;
   short int                       groups = (short) 1;
   gpr_$version_t                  version;
   gpr_$offset_t                   disk_bm_size;
   gpr_$window_t                   scanline;
   gpr_$bmf_group_header_array_t   header;
   gpr_$pixel_value_t              pixel_32_array[MAXLINE];      
   gpr_$color_vector_t             color_map;
   gpr_$bitmap_desc_t              junk_desc , disk_bitmap_desc;
   boolean                         created;

   int x,y,i;
   unsigned char pixel_8;

   rle_pixel scandata [3][MAXLINE] , *outrows[3];          /* RLE stuff */

   progname = strrchr(argv[0], '/');
   if (progname)
       progname++;
    else
       progname = argv[0];

    if (argc != 2)  usage ();

/*  Initialize the GPR library with a 1x1 dummy bitmap in main memory */
    disk_bm_size.x_size = (short) 1;
    disk_bm_size.y_size = (short) 1;
    gpr_$init(gpr_$no_display, (stream_$id_t) 0, disk_bm_size, (gpr_$plane_t) 0, &junk_desc, &status);
    check("in main, after calling gpr_$init");

    gpr_$allocate_attribute_block(&attribs, &status);
    check("in main, after calling gpr_$allocate_attribute_block");
    gpr_$open_bitmap_file(gpr_$readonly, argv[1], (short)strlen(argv[1]), &version,
        &disk_bm_size, &groups, header, attribs, &disk_bitmap_desc, &created, &status);
    check("in main, after calling gpr_$open_bitmap_file");

fprintf(stderr,"Image Characteristics    \n");
fprintf(stderr,"  Image Size        : %d  %d \n",disk_bm_size.x_size,disk_bm_size.y_size);
fprintf(stderr,"  Number of groups  : %d \n",groups);
fprintf(stderr,"  Number of planes  : %d \n",header[0].n_sects);
fprintf(stderr,"  Pixel size        : %d \n",header[0].pixel_size);
fprintf(stderr,"  Allocated Size    : %d \n",header[0].allocated_size);
fprintf(stderr,"  Bytes per line    : %d \n",header[0].bytes_per_line);
fprintf(stderr,"  Bytes per section : %d \n",header[0].bytes_per_sect);

   if(header[0].n_sects == 1) 
     { 
      color_map[0] =  gpr_$black ;
      color_map[1] =  gpr_$white ;
      fprintf(stderr,"  Internal Colormap : false . Using Black and White. \n");
     }
   else
     {
       gpr_$inq_bitmap_file_color_map(disk_bitmap_desc, (short) 0,(short) 256, color_map, &status);   
       if((status.all == gpr_$no_color_map_in_file) || (status.all == gpr_$invalid_color_map) )
              {        
                error_$print (status);
                gpr_$inq_color_map((gpr_$pixel_value_t) 0, (short) 256, color_map, &status); 
                check("in main, after calling gpr_$inq_color_map"); 
                fprintf(stderr,"  Internal Colormap : false . Using this workstation's color map. \n");
              }
       else  
              {
               check("in main, after calling gpr_$inq_bitmap_file_color_map");
               fprintf(stderr,"  Internal Colormap : true \n");
              }
     }

/* Set the current bitmap to be the GPR bitmap file */
   gpr_$set_bitmap(disk_bitmap_desc, &status);
   check("in main, after calling gpr_$set_bitmap");

    rle_dflt_hdr.rle_file    = stdout;                           /* RLE stuff */
    rle_dflt_hdr.xmin    = 0 ;                                   /* RLE stuff */
    rle_dflt_hdr.xmax    = disk_bm_size.x_size - 1;              /* RLE stuff */
    rle_dflt_hdr.ymin    = 0 ;                                   /* RLE stuff */
    rle_dflt_hdr.ymax    = disk_bm_size.y_size - 1;              /* RLE stuff */
    rle_dflt_hdr.alpha   = 0;                                    /* RLE stuff */
    rle_dflt_hdr.ncolors = 3;                                    /* RLE stuff */

    rle_put_setup( &rle_dflt_hdr );                              /* RLE stuff */

    scanline.window_base.x_coord = (short) 0;
    scanline.window_size.x_size  = (short) disk_bm_size.x_size;
    scanline.window_size.y_size  = (short) 1;

    for (y=disk_bm_size.y_size - 1 ; y >= 0 ; y--)
     {       
       scanline.window_base.y_coord = y;
       gpr_$read_pixels(scanline, pixel_32_array, &status);
       check("in main, after calling gpr_$read_pixels");
       for (x=0 ; x < disk_bm_size.x_size ; x++)
         {                                        
/* if(pixel_32_array[x] > 255) fprintf(stderr,"Warning: pixel value greater than 255, pixel=%d \n",pixel_32_array[x]); */
           pixel_8 = (unsigned char) pixel_32_array[x];  
           scandata[0][x] = (color_map[pixel_8] / 65536) & 0xFF;
           scandata[1][x] = (color_map[pixel_8] / 256  ) & 0xFF;
           scandata[2][x] = (color_map[pixel_8]        ) & 0xFF;
          }

        for (i=0 ; i<3 ; i++) outrows[i] = scandata[i];           /* RLE stuff */
        rle_putrow(outrows, disk_bm_size.x_size, &rle_dflt_hdr);  /* RLE stuff */
      }        

    gpr_$terminate(false, &status);

}

