 /*
  * General front end for connection-oriented tcp/ip services. This program
  * logs the remote host name and then invokes the real daemon. For example,
  * install as /usr/etc/{fingerd,telnetd,ftpd,rlogind,rshd,rexecd}, after
  * saving the real daemons in the directory "/usr/etc/...". This arrangement
  * requires that the network daemons are started by inetd or something
  * similar. Connections and diagnostics are logged through syslog(3).
  * 
  * Compile with -DHOSTS_ACCESS in order to enable access control. See the
  * hosts_access(5) manual page for details.
  * 
  * Author: Wietse Venema, Eindhoven University of Technology, The Netherlands.
  */

#ifndef lint
static char sccsid[] = "@(#) tcpd.c 1.1 91/01/06 22:30:36";
#endif

#include <stdio.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/param.h>
#ifndef MAXPATHNAMELEN
#define MAXPATHNAMELEN	BUFSIZ
#endif

/* The following specifies where the vendor-provided daemons should go. */

#ifndef REAL_DAEMON_DIR
#define REAL_DAEMON_DIR	"/usr/etc/..."
#endif

main(argc, argv)
int     argc;
char  **argv;
{
    char   *fromhost();
    char   *host_name;
    char    path[MAXPATHNAMELEN];

    /*
     * Open a channel to the syslog daemon. Older versions of openlog()
     * require only two arguments.
     */

#ifdef LOG_DAEMON
    (void) openlog(argv[0], LOG_PID, LOG_DAEMON);
#else
    (void) openlog(argv[0], LOG_PID);
#endif

    /* Find out and report the remote host name. */

    if ((host_name = fromhost()) == 0)
	host_name = "unknown";
    syslog(LOG_INFO, "connect from %s", host_name);

    /* Check whether this host can access the service in argv[0]. */

#ifdef HOSTS_ACCESS
    hosts_access(argv[0], host_name);
#endif

    /* Invoke the real daemon program. */

    (void) sprintf(path, "%s/%s", REAL_DAEMON_DIR, argv[0]);
    (void) execv(path, argv);
    syslog(LOG_ERR, "%s: %m", path);
    return (1);
}
