 /*
  * fromhost() returns the name or address of the host at the other end of
  * standard input, "stdin" if it is connected to a terminal, or a null
  * pointer if it fails. Diagnostics are logged through syslog(3).
  * 
  * Author: Wietse Venema, Eindhoven University of Technology, The Netherlands.
  */

#ifndef lint
static char sccsid[] = "@(#) fromhost.c 1.1 91/01/06 22:30:24";
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <syslog.h>
#include <netinet/in.h>
#include <netdb.h>

/* fromhost - find out what is at the other end of standard input */

char   *fromhost()
{
    struct sockaddr sa;
    struct sockaddr_in *sin = (struct sockaddr_in *) (&sa);
    struct hostent *hp;
    int     sockt = fileno(stdin);
    int     length = sizeof(sa);
    char   *inet_ntoa();

    if (getpeername(sockt, &sa, &length) < 0) {
	if (isatty(sockt)) {
	    return ("stdin");
	} else {
	    syslog(LOG_ERR, "getpeername: %m");
	    return (0);
	}
    } else {
	switch (sa.sa_family) {
	case AF_INET:
	    hp = gethostbyaddr((char *) &sin->sin_addr.s_addr,
			       sizeof(sin->sin_addr.s_addr), AF_INET);
	    return (hp ? hp->h_name : inet_ntoa(sin->sin_addr));
	default:
	    syslog(LOG_ERR, "unknown address family %ld", sa.sa_family);
	    return (0);
	}
    }
}
