 /*
  * Wrapper around connection-oriented services. This program logs all
  * connections and invokes the real daemon. For example, install as
  * /usr/etc/{fingerd,telnetd,ftpd,rlogind,rshd,rexecd}, after saving the
  * real daemons in the directory "/usr/etc/...".
  * 
  * Author: Wietse Z. Venema.
  */

#define	REAL_DAEMON_DIR	"/etc/org-daemons"

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <syslog.h>
#include <netinet/in.h>
#include <netdb.h>

main(argc, argv)
int     argc;
char  **argv;
{
    int     sockt;
    int     length;
    struct sockaddr sa;
    struct sockaddr_in *sin = (struct sockaddr_in *) (&sa);
    char    host_name[MAXHOSTNAMELEN];
    struct hostent *hp;
    char   *strcpy();
    char   *inet_ntoa();
    void    exit();
    void    syslog();
    char    path[BUFSIZ];

    sockt = fileno(stdin);
    length = sizeof(sa);

#ifdef	LOG_MAIL
    (void) openlog(argv[0], LOG_PID, LOG_DAEMON);
#else
    (void) openlog(argv[0], LOG_PID);
#endif

    if (getpeername(sockt, &sa, &length) < 0) {
	if (isatty(sockt)) {
	    (void) strcpy(host_name, "stdin");
	} else {
	    syslog(LOG_ERR, "getpeername: %m");
	    (void) strcpy(host_name, "unknown");
	}
    } else {
	switch (sa.sa_family) {
	case AF_INET:
	    hp = gethostbyaddr((char *) &sin->sin_addr.s_addr,
			       sizeof(sin->sin_addr.s_addr), AF_INET);
	    if (hp != NULL)
		(void) strcpy(host_name, hp->h_name);
	    else
		(void) strcpy(host_name, inet_ntoa(sin->sin_addr));
	    break;

	default:
	    syslog(LOG_ERR, "unknown address family %ld", sa.sa_family);
	    (void) strcpy(host_name, "unknown");
	}
    }

    syslog(LOG_INFO, "connect from %s", host_name);

    /* Construct path to real daemon and invoke it */

    (void) sprintf(path, "%s/%s", REAL_DAEMON_DIR, argv[0]);
    (void) execv(path, argv);
    syslog(LOG_ERR, "%s: %m", path);
}
