/*
    Program to open DM edit pads on files and wait until they're closed.

    Tom Lyons   (tbl@apollo.com)

    Modified by Jim Richardson:
	exit with status 1 if user aborts any of the edits	29 Nov 1989
	add -r flag						 1 Dec 1989
*/

#include    <stdio.h>
#include    <string.h>
#include    <apollo/base.h>
#include    <apollo/pad.h>
#include    <apollo/error.h>

#define DISPLAY_UNIT    (1)

static char usage[] = "Usage: %s [-r] pathname [pathname ...]\n";

int
main(int argc, char *argv[])
{
    pad_$window_desc_t  window;
    ios_$id_t           stream;
    status_$t           status;
    char                *command;
    pad_$type_t		edit_mode = pad_$edit;
    int                 index;
    int                 quitted = 0;

    if (NULL == (command = strrchr(argv[0], '/')))
	command = argv[0];
    else
	++command;

    if (2 > argc)   {
	fprintf(stderr, usage, command);
	exit(1);
    }

    if (argv[1][0] == '-')   {
	if (argv[1][1] == 'r')   {
	    edit_mode = pad_$read_edit;
	    argv++;
	    argc--;
	    if (2 > argc)   {
		fprintf(stderr, usage, command);
		exit(1);
	    }
	}
	else   {
	fprintf(stderr, usage, command);
	exit(1);
	}
    }

    window.top = window.left = window.width = window.height = 0;

    for (index = 1; index < argc; ++index)  {

	pad_$create_window( argv[index],
			    (unsigned short)strlen(argv[index]),
			    edit_mode, DISPLAY_UNIT, window,
			    &stream, &status    );

	if (status_$ok != status.all)   {
	    fprintf(stderr, "%s: ", command);
	    fflush(stderr);
	    error_$print(status);
	    exit(2);
	}

	pad_$edit_wait(stream, &status);

	if (status_$ok != status.all)   {

	    fprintf(stderr, "%s: ", command);

	    if (pad_$edit_quit == status.all)   {
		fprintf(stderr, "File \"%s\" - ", argv[index]);
		fflush(stderr);
		error_$print(status);
		quitted = 1;
	    }
	    else    {
		fflush(stderr);
		error_$print(status);
		exit(3);
	    }

	}

    }

    exit( quitted );
}
