#include <stdio.h>
#include <sys/types.h>

/*
 * determines initial directory acls
 *
 * Mark C. DiVecchio
 * Silogic Systems
 * August 15, 1990
 * 619-549-9841
 */

/* parses the output of the command "lsacl -Lad".

a well protected directory would look like this

	mcd.%.%             	------UP
	%.silogic.%         	------U
	%.%.mentor          	-----I
	%.%.%               	------U

a bad directory would look like this :

	mcd.%.%			prwx---P
	%.silogic.%		prwx---P
	%.%.mentor		-----I-P
	%.%.%			prwx-

this program looks at the world 'p' and 'w', the orgainzation 'p' and 'w' and
the group 'p' and 'w' bits.

If group check is requested, organization is also checked.

return a 1 if writeable.

*/

main(argc,argv)
char **argv;
{
	register int group = 0, xmode = 0;
	char str[80];
	FILE *fptr;

	if (argc < 2) {
		printf("Usage: %s [-g] directory\n",argv[0]);
		exit(0);
	}

	if (argc > 2) {
		if (!strcmp(argv[1], "-g")) {
			group = 1;
			argc--;
			argv++;
		}
	}

	sprintf(str,"lsacl -Lad %s", *++argv);
	fptr = popen(str,"r");

	/* read user */
	fscanf(fptr,"%s",str);
		/* read user permissions */
		fscanf(fptr,"%s",str);

	/* read group */
	fscanf(fptr,"%s",str);
		/* read group permissions */
		fscanf(fptr,"%s",str);
		if (group && (str[2] == 'w' || str[0] == 'p')) xmode = 1;

	/* read organization */
	fscanf(fptr,"%s",str);
		/* read orgainzation permissions */
		fscanf(fptr,"%s",str);
		if (group && (str[2] == 'w' || str[0] == 'p')) xmode = 1;

	/* read world */
	fscanf(fptr,"%s",str);
		/* read world permissions */
		fscanf(fptr,"%s",str);
		if (str[2] == 'w' || str[0] == 'p') xmode = 1;

	pclose(fptr);
	exit(!xmode);
}


