(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)
(*                                                             *)
(* Last modified on Tue Oct 18 08:40:23 PDT 1994 by kalsow     *)
(*      modified on Fri Apr 30 16:25:40 PDT 1993 by muller     *)
(*      Olaf Wagner 12.09.1994                                 *)
(*      Phil Nelson 17.05.1999                                 *)

INTERFACE Csetjmp;		(* for NetBSD *)

FROM Ctypes IMPORT int;

TYPE 
  jmp_buf = ARRAY [0..28] OF int; (* actually, this is a sigjmp_buf,
                                     just in case *)

<*EXTERNAL "sigsetjmp" *>
PROCEDURE setjmp (VAR env: jmp_buf; savemask := 1): int;
<*EXTERNAL "siglongjmp" *>
PROCEDURE longjmp (VAR env: jmp_buf; val: int);

<*EXTERNAL "sigsetjmp" *>
PROCEDURE usetjmp (VAR env: jmp_buf; savemask := 0): int;
<*EXTERNAL "siglongjmp" *>
PROCEDURE ulongjmp (VAR env: jmp_buf; val: int);

END Csetjmp.

