(* Copyright (C) 1994, Digital Equipment Corporation *)
(* All rights reserved.                              *)
(* See the file COPYRIGHT for a full description.    *)

(* This interface exports the configuration information
   used by m3build and quake.  These constants were defined
   when Modula-3 was installed. *)

INTERFACE M3Config;

CONST  (* misc. configuration *)
  M3_VERSION       = "ezm3-1.0";
  M3_VERSION_DATE  = "Sun Dec 30 23:59:04 UTC 2001";
  TARGET    = "ALPHA_OSF";
  OS_TYPE   = "POSIX";
  WORD_SIZE = "64BITS";
  BUILD_DIR = "ALPHA_OSF";
  PATH_SEP  = "/";

CONST (* installation directories *)
  BIN_INSTALL   = "/usr/local/bin";
  LIB_INSTALL   = "/usr/local/lib/m3/ALPHA_OSF";
  DOC_INSTALL   = "/usr/local/doc/pm3";
  PKG_INSTALL   = "/usr/local/lib/m3/pkg";
  MAN_INSTALL   = "/usr/local/man";
  EMACS_INSTALL = "/usr/local/lib/elisp";
  HTML_INSTALL  = "/usr/local/lib/m3/www";

(* On some systems (e.g. AFS) you must install public files
   in a different place from where you use them.  The paths
   below specify where to find the installed files. *)

CONST
  BIN_USE   = "/usr/local/bin";
  LIB_USE   = "/usr/local/lib/m3/ALPHA_OSF";
  DOC_USE   = "/usr/local/doc/pm3";
  PKG_USE   = "/usr/local/lib/m3/pkg";
  MAN_USE   = "/usr/local/man";
  EMACS_USE = "/usr/local/lib/elisp";
  HTML_USE  = "/usr/local/lib/m3/www";

END M3Config.
