/******************************************************************************
*******************************************************************************
*
*  (c) Copyright 1989, DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
*  ALL RIGHTS RESERVED
*  
*  	THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
*  NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY OPEN DIGITAL
*  EQUIPMENT CORPORATION OR ITS THIRD PARTY SUPPLIERS  
*  
*  DIGITAL EQUIPMENT CORPORATION AND ITS THIRD PARTY SUPPLIERS,
*  ASSUME NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE ANY OF ITS
*  SOFTWARE .   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
*  KIND, AND DIGITAL EQUIPMENT CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
*  WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
*  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*  
* DEC is a registered trademark of Digital Equipment Corporation
* DIGITAL is a registered trademark of Digital Equipment Corporation
* X Window System is a trademark of the Massachusetts Institute of Technology
*
*******************************************************************************
******************************************************************************/

/*
 * File:	cdutil.c
 * Author:	Robin T. Miller
 * Date:	January 25, 1991
 *
 * Modified: 	Mark Clement
 * Date:		April 4, 1991
 *
 * Modified: 	Mark Longo
 * Date:        November 20, 1991
 *
 * Added PlayTime routine to play a segment of the disk addressed by
 * a start and end play time.  This code is courtesy of Jon Reeves.
 * 
 * Description:
 *	This file contains various utility functions.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/rzdisk.h>
#include "cdutil.h"

extern caddr_t valloc();

/* Make this a global so that it doesn't have to be passed to all of
 * the routines.
 */
int CdFd;	/* File descriptor for CDROM */

/************************************************************************
 *									*
 * DoIoctl()	Do An I/O Control Command.				*
 *									*
 * Description:								*
 *	This function issues the specified I/O control command to the	*
 * xpr psuedo device driver.						*
 *									*
 * Inputs:	cmd = The I/O control command.				*
 *		argp = The command argument to pass.			*
 *		msgp = The message to display on errors.		*
 *									*
 * Return Value:							*
 *		Returns 0 / -1 = CD_SUCCESS / FAILURE.			*
 *									*
 ************************************************************************/
int
DoIoctl (cmd, argp, msgp)
int cmd;
caddr_t argp;
caddr_t msgp;
{
	int status;

/*
	if ((status = ioctl (CdFd, cmd, argp)) < 0) {
		perror (msgp);
	}
*/
	if(CdFd) {
		status = ioctl (CdFd, cmd, argp);
		return (status);
	} else
		return(-1);
}
int
StopUnit()
{
	int cmd = SCSI_STOP_UNIT;
	caddr_t argp = (caddr_t) 0;
	caddr_t msgp = "SCSI_STOP_UNIT";

	return (DoIoctl (cmd, argp, msgp));
}

int
EjectUnit()
{
	int cmd = CDROM_EJECT_CADDY;
	caddr_t argp = (caddr_t) 0;
	caddr_t msgp = "CDROM_EJECT_CADDY";

	return (DoIoctl (cmd, argp, msgp));
}

int
PausePlay()
{
	int cmd = CDROM_PAUSE_PLAY;
	caddr_t argp = (caddr_t) 0;
	caddr_t msgp = "CDROM_PAUSE_PLAY";

	return (DoIoctl (cmd, argp, msgp));
}

int
ResumePlay()
{
	int cmd = CDROM_RESUME_PLAY;
	caddr_t argp = (caddr_t) 0;
	caddr_t msgp = "CDROM_RESUME_PLAY";

	return (DoIoctl (cmd, argp, msgp));
}

int
PreventRemoval()
{
	int cmd = SCSI_PREVENT_REMOVAL;
	caddr_t argp = (caddr_t) 0;
	caddr_t msgp = "SCSI_PREVENT_REMOVAL";

	return (DoIoctl (cmd, argp, msgp));
}

int
AllowRemoval()
{
	int cmd = SCSI_ALLOW_REMOVAL;
	caddr_t argp = (caddr_t) 0;
	caddr_t msgp = "SCSI_ALLOW_REMOVAL";

	return (DoIoctl (cmd, argp, msgp));
}

int
PlayTrack (starting_track, ending_track)
int starting_track, ending_track;
{
	struct cd_play_audio_ti play_audio_ti;
	register struct cd_play_audio_ti *ti = &play_audio_ti;
	int cmd = CDROM_PLAY_AUDIO_TI;
	caddr_t argp = (caddr_t) ti;
	caddr_t msgp = "CDROM_PLAY_AUDIO_TI";

	bzero ((char *) ti, sizeof(*ti));
	ti->ti_starting_track = starting_track;
	ti->ti_ending_track = ending_track;
	ti->ti_starting_index = 1;
	ti->ti_ending_index = 1;
	return (DoIoctl (cmd, argp, msgp));
}

int
PlayTime (starting_time, ending_time)
union cd_address starting_time, ending_time;
{
	struct cd_play_audio_msf play_audio_msf;
	register struct cd_play_audio_msf *msf = &play_audio_msf;
	int cmd = CDROM_PLAY_AUDIO_MSF;
	caddr_t argp = (caddr_t) msf;
	caddr_t msgp = "CDROM_PLAY_AUDIO_MSF";

	bzero ((char *) msf, sizeof(*msf));
	msf->msf_starting_M_unit = starting_time.msf.m_units;
	msf->msf_starting_S_unit = starting_time.msf.s_units;
	msf->msf_starting_F_unit = starting_time.msf.f_units;
	msf->msf_ending_M_unit = ending_time.msf.m_units;
	msf->msf_ending_S_unit = ending_time.msf.s_units;
	msf->msf_ending_F_unit = ending_time.msf.f_units;
	return (DoIoctl (cmd, argp, msgp));
}

int
SetAddrFormatMsf()
{
	int cmd = CDROM_SET_ADDRESS_FORMAT;
	int arg = CDROM_MSF_FORMAT;
	caddr_t msgp = "CDROM_SET_ADDRESS_FORMAT";

	return (DoIoctl (cmd, &arg, msgp));
}

/************************************************************************
 *									*
 * GetTotalTracks() - Get Total Tracks on the CD-ROM.			*
 *									*
 * Inputs:	None.							*
 *									*
 * Return Value:							*
 *		Returns total tracks Table of Contents.			*
 *									*
 ************************************************************************/
int
GetTotalTracks()
{
	register struct cd_toc_header toc_header;
	register struct cd_toc_header *th = &toc_header;
	int status;

	if ( (status = GetTOCHeader (th)) != CD_SUCCESS) {
		return (FAILURE);
	}
	return ((th->th_ending_track - th->th_starting_track) + 1);
}

/************************************************************************
 *									*
 * GetPlayPosition() - Get Current Play CD-ROM Position Information.	*
 *									*
 * Inputs:	sci = Pointer to sub-channel information structure.	*
 *									*
 * Return Value:							*
 *		Returns 0 / -1 = CD_SUCCESS / FAILURE.			*
 *									*
 ************************************************************************/
int
GetPlayPosition (sci)
register struct cd_subc_information *sci;
{
	struct cd_sub_channel sub_channel;
	register struct cd_sub_channel *sch = &sub_channel;
	register struct cd_subc_header *sh = &sci->sci_header;
	register struct cd_subc_position *scp = &sci->sci_scp;
	int cmd = CDROM_READ_SUBCHANNEL;
	caddr_t argp = (caddr_t) sch;
	caddr_t msgp = "CDROM_READ_SUBCHANNEL";
	int length, err;

	length = sizeof(*sh) + sizeof(*scp);
	bzero ((char *)sch, sizeof(*sch));
	sch->sch_address_format = CDROM_MSF_FORMAT;
	sch->sch_data_format = CDROM_CURRENT_POSITION;
	sch->sch_track_number = 0;
	sch->sch_alloc_length = (u_short) length;
	sch->sch_buffer = (caddr_t) sci;
	return (DoIoctl (cmd, argp, msgp));
}

/************************************************************************
 *									*
 * GetTOCHeader() - Get The CD-ROM Table Of Contents Header.		*
 *									*
 * Inputs:	th = Pointer to TOC header structure.			*
 *									*
 * Return Value:							*
 *		Returns 0 / -1 = CD_SUCCESS / FAILURE.			*
 *									*
 ************************************************************************/
int
GetTOCHeader (th)
register struct cd_toc_header *th;
{
	int cmd = CDROM_TOC_HEADER;
	caddr_t argp = (caddr_t) th;
	caddr_t msgp = "CDROM_TOC_HEADER";
	int status;

	return (DoIoctl (cmd, argp, msgp));
}

/************************************************************************
 *									*
 * SetVolume()  Set CD-ROM Volume Control.				*
 *									*
 * Inputs:	left_channel_volume = Left channel volume level.	*
 *		right_channel_volume = Right channel volume level.	*
 *									*
 * Return Value:							*
 *		Returns 0 / -1 = CD_SUCCESS / FAILURE.			*
 *									*
 ************************************************************************/
int
SetVolume (left_channel_volume, right_channel_volume)
int left_channel_volume, right_channel_volume;
{
    struct cd_playback playback;
    struct cd_playback_status playback_status;
    struct cd_playback_control playback_control;
    register struct cd_playback *pb = &playback;
    register struct cd_playback_status *ps = &playback_status;
    register struct cd_playback_control *pc = &playback_control;
    int cmd = CDROM_PLAYBACK_CONTROL;
    caddr_t argp = (caddr_t) pb;
    caddr_t msgp = "CDROM_PLAYBACK_CONTROL";
    int status;
	
    bzero ((char *)pb, sizeof(*pb));
    bzero ((char *)pc, sizeof(*pc));
    bzero ((char *)ps, sizeof(*ps));

    pb->pb_alloc_length = sizeof(*pc);
    pb->pb_buffer = (caddr_t) pc;

    if ( (status = GetPlaybackStatus(ps)) != CD_SUCCESS)
      {
	return (status);
      }

    /*
     * NOTE: The current firmware only supports channels 0 & 1.
     */
    
    pc->pc_chan0_select = ps->ps_chan0_select;
    pc->pc_chan0_volume = left_channel_volume;
    
    pc->pc_chan1_select = ps->ps_chan1_select;
    pc->pc_chan1_volume = right_channel_volume;
    
    return (DoIoctl (cmd, argp, msgp));
}

/************************************************************************
 *									*
 * GetPlaybackStatus() - Get The CD-ROM Playback Status.		*
 *									*
 * Inputs:	ps = Pointer to playback status structure.		*
 *									*
 * Return Value:							*
 *		Returns 0 / -1 = CD_SUCCESS / FAILURE.			*
 *									*
 ************************************************************************/
int
GetPlaybackStatus (ps)
register struct cd_playback_status *ps;
{
	struct cd_playback playback;
	register struct cd_playback *pb = &playback;
	int cmd = CDROM_PLAYBACK_STATUS;
	caddr_t argp = (caddr_t) pb;
	caddr_t msgp = "CDROM_PLAYBACK_STATUS";
	int status;

	bzero ((char *)pb, sizeof(*pb));
	pb->pb_alloc_length = sizeof(*ps);
	pb->pb_buffer = (caddr_t) ps;
	return (DoIoctl (cmd, argp, msgp));
}

/************************************************************************
 *									*
 * GetTOC() - Get The Table Of Contents.				*
 *									*
 * Inputs:	toc_buffer = Pointer to TOC buffer.			*
 *									*
 * Return Value:							*
 *		Returns 0 / -1 = CD_SUCCESS / FAILURE.			*
 *									*
 ************************************************************************/
int
GetTOC (toc_buffer)
	struct cd_toc_head_and_entries *toc_buffer;
{
	int status, length;
	struct cd_toc Toc;
	int cmd = CDROM_TOC_ENTRYS;
	caddr_t argp = (caddr_t) &Toc;
	caddr_t msgp = "CDROM_TOC_ENTRYS";
	struct cd_toc_header *th;

	th = &toc_buffer->cdth;
	if ( (status = GetTOCHeader (th)) != CD_SUCCESS) {
		return (FAILURE);
	}
	length = (int) ( ( (th->th_data_len1 << 8) +
			  th->th_data_len0) & 0xffff) + 2;
	Toc.toc_address_format = CDROM_MSF_FORMAT;
	Toc.toc_starting_track = 0;
	Toc.toc_alloc_length = (u_short) length;
	Toc.toc_buffer = (char *)toc_buffer;

	if ( (status = DoIoctl (cmd, argp, msgp)) != 0) {
		return (status);
	}

	return (status);
}

set_fd(fd)
	int fd;
{

	CdFd = fd;
}
