/* sys/execname.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#define INCL_DOS
#include <os2emx.h>
#include <string.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __execname (char *dst, size_t size)
{
  ULONG rc;
  PTIB ptib;
  PPIB ppib;

  if (size == 0)
    return -1;

  rc = DosGetInfoBlocks (&ptib, &ppib);
  if (rc != 0)
    {
      *dst = 0;
      return -1;
    }

  rc = DosQueryModuleName (ppib->pib_hmte, size, dst);
  if (rc != 0)
    {
      *dst = 0;
      return -1;
    }
  return 0;
}
