/ isnorm.s (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes

#include <emx/asm386.h>

#define FUNC    MATHSUFFIX3(__isnormal)

        .globl  LABEL(FUNC)

        .text

        ALIGN

#if defined (LONG_DOUBLE)

/ int __isnormall (long double x)

#define x       4(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        fldt    x
        fxam
        fstsww  %ax
        fstp    %st(0)
        movb    %ah, %al
        andl    $0x45, %eax
        cmpb    $0x04, %al
        sete    %al
        EPILOGUE(FUNC)

#elif defined (FLOAT)

/ int __isnormalf (float x)

#define x       4(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movl    x, %edx
        xorl    %eax, %eax
        andl    $0x7fffffff, %edx
        subl    $0x00800000, %edx
        cmpl    $0x7f000000, %edx
        setb    %al
        EPILOGUE(FUNC)

#else

/ int __isnormal (double x)

#define x0      4(%esp)
#define x4      8(%esp)

LABEL(FUNC):
        PROFILE_NOFRAME
        movl    x4, %edx
        xorl    %eax, %eax
        andl    $0x7ff00000, %edx
        subl    $0x00100000, %edx
        cmpl    $0x7fe00000, %edx
        setb    %al
        EPILOGUE(FUNC)

#endif
