/* defshrink.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <stddef.h>
#include <umalloc.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <emx/umalloc.h>

void _um_default_shrink (Heap_t h, void *memory, size_t old_size,
                         size_t *new_size)
{
  void *cur;

  cur = _sbrk (0);
  if (_UM_ADD (memory, old_size) != cur
      || _sbrk ((int)(*new_size - old_size)) == (void *)-1)
    *new_size = old_size;
}
