
/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: execl.c   SID: 2.1 8/6/89 22:24:25
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 *  $Header: execl.c,v 3.5 87/06/22 15:37:08 kjmcdonell Beta $
 *
 ******************************************************************************/
/*
 *  Execing
 *
 */

char	bss[8*1024];	/* something worthwhile */

#define main dummy
			/* some reasonable code etc. */
#include "big.c"

#undef main

/* added by BYTE */
char fullpath[81] = {"./execl"};
char *getenv();

main(argc, argv)	/* the real program */
int	argc;
char	*argv[];
{
	char *ptr; /* BYTE */
	int	iter;
	char	count[6];

	if (argc != 2) {
		printf("Usage: %s count\n", argv[0]);
		exit(1);
	}

	/* added by BYTE */
	if((ptr = getenv("BINDIR")) != NULL)
		sprintf(fullpath,"%s/execl",ptr);

	iter = atoi(argv[1]);

	if (iter) {
		sprintf(count, "%d", --iter);
		execl(fullpath, fullpath, count, 0);
		printf("Exec failed at iteration %d\n", iter);
		perror("Reason");
		exit(1);
	}
	exit(0);
}
