
/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: context1.c   SID: 2.1 8/6/89 22:24:25
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 *  $Header: context1.c,v 3.4 87/06/22 14:22:59 kjmcdonell Beta $
 *
 ******************************************************************************/
char SCCSid[] = "@(#) @(#)context1.c:2.1 -- 8/6/89 22:24:25";
/*
 *  Context switching via synchronized unbuffered pipe i/o
 *
 */

main(argc, argv)
int	argc;
char	*argv[];
{
	int	check;
	int	iter;
	int	p1[2], p2[2];

	if (argc != 2) {
		printf("Usage: context count\n");
		exit(1);
	}

	iter = atoi(argv[1]);
	if (pipe(p1) || pipe(p2)) {
		perror("pipe create failed");
		exit(1);
	}

	if (fork()) {
		/* master, write p1 & read p2 */
		close(p1[0]); close(p2[1]);
		while (iter > 0) {
			if (write(p1[1], (char *)&iter, sizeof(iter)) != sizeof(iter)) {
				perror("master write failed");
				exit(1);
			}
			if (read(p2[0], (char *)&check, sizeof(check)) != sizeof(check)) {
				perror("master read failed");
				exit(1);
			}
			if (check != iter) {
				printf("Master sync error: expect %d, got %d\n",
					iter, check);
				exit(2);
			}
			iter--;
		}
	}
	else {
		/* slave, read p1 & write p2 */
		close(p1[1]); close(p2[0]);
		while (iter > 0) {
			if (read(p1[0], (char *)&check, sizeof(check)) != sizeof(check)) {
				perror("slave read failed");
				exit(1);
			}
			if (check != iter) {
				printf("Slave sync error: expect %d, got %d\n",
					iter, check);
				exit(2);
			}
			if (write(p2[1], (char *)&iter, sizeof(iter)) != sizeof(check)) {
				perror("slave write failed");
				exit(1);
			}
			iter--;
		}
	}
	exit(0);
}
