/*
  OS
  A veneer to simple library and OS services
  Trivially implemented on ANSI platforms, but the Psion
  gives better performance when the ANSI library is not used.
  JBS 15 June 1994
*/

#ifndef _OS_

#define _OS_

#include "types.h"

typedef void *filep;

filep os_open_read(const char *);
filep os_wild_read(const char *); /* Search drives */
filep os_open_write(const char *);
filep os_open_append(const char *);
int os_close(filep);
int os_seek_fore(filep, long_word);
int os_seek_back(filep, long_word);
int os_read(void *, size_t, int, filep);
int os_write(void *, size_t, int, filep);

void os_exit(int);

void os_mcpy(void *, void *, size_t);
void os_mset(char *, size_t, char);

void os_strcpy(char *, const char *);
void os_strcat(char *, const char *);
int os_strlen(const char *);
int os_strcmp(const char *, const char *);

void *os_alloc(size_t);
void os_free(void *);
void *os_realloc(void *, size_t);

char os_lower(char);

long_word os_time(void);

char *os_leaf(char *);

void os_patch_save(char *); /* Normalise to a save position filename */

int os_strpos(char *, char);

#endif /* __MACHINE__ */
