/*
  Arith
  Simple arithmetic opcodes
  JBS 15 June 1994
*/

#ifndef _ARITH_

#define _ARITH_

#include "types.h"

#define plus(a,b)       store((a)+(b))
#define minus(a,b)      store((a)-(b))
#define multiply(a,b)   store((signed_word)(a) * (signed_word)(b))
#define divide(a,b)     store((signed_word)(a) / (signed_word)(b))
#define mod(a,b)        store((signed_word)(a) % (signed_word)(b))
#define or(a,b)         store((a)|(b))
#define and(a,b)        store((a)&(b))
#define not(a)          store(~(a))

#define less_than(a,b)     ret_value((signed_word) (a) < (signed_word) (b))
#define greater_than(a,b)  ret_value((signed_word) (a) > (signed_word) (b))

#define cp_zero(a)      ret_value((a) == 0)
#define bit(a,b)        ret_value(((b) & ~(a)) == 0)

void logical_shift(word, word);
void arithmetic_shift(word, word);

#endif
