/* Yasym.c   17-Oct-86 		Phase 1 symbol table management routines */
/* 17-Oct-86 Derived from gsym.c */
/* 17-Oct-86 Addsym() sets sym->kind to NONE */
/* 25-Jul-87 IBM */
/* 09-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	chksym()	fndsym()	addsym()
			ithash()	fnhash()

	Statics:	hash()
*/

#include <stdio.h>

#define	PHASE1

#include "yadefs.h"

static SYMBOL **hashtab;		/* Hash tables are */
static int *hashlength;			/* dynamically allocated */

SYMBOL *chksym(s)			/* find symbol s or add it */
char *s;
{
    int h;
    SYMBOL *p,*fndsym(),*addsym();

    h=hash(s);
    if ((p=fndsym(s,h)) != NULL)
	return p;
    else
	return addsym(s,h);
}

SYMBOL *fndsym(s,h)				/* find symbol named s */
char *s;
int h;
{
    SYMBOL *p;
    int l;

    p=hashtab[h];
    l=hashlength[h];
    while (l-- && p != NULL) {
	if (!strcmp(s,p->name))
	    return p;
	else
	    p=p->lsym;
    }
    return NULL;
}

SYMBOL *addsym(s,h)				/* add a new symbol named s */
char *s;
int h;
{
    int l;
    SYMBOL *p,*p2;

    p=(SYMBOL *) xalloc(sizeof(SYMBOL));	/* type name K&P 8.7 */
    p->name=xalloc(strlen(s)+1);		/* space for \0 */
    strcpy(p->name,s);

    p->kind=NONE;

    l=hashlength[h]++;				/* length of chain for h */

    if (l) {					/* are already hash entries */
	p2=hashtab[h];				/* first entry in hash chain */
	while (--l) {				/* find last in hash chain */
	    p2=p2->lsym;
	}
	p->lsym=p2->lsym;			/* insert p after p2 */
	p2->lsym=p;
    }
    else {					/* hash table empty at h */
	hashtab[h]=p;				/* put entry in hash table */
	p->lsym=shead;				/* insert p at shead */
	shead=p;
    }

    return p;
}

static int hash(s)
char *s;
{
    int i;

    i=0;
    while (*s) {
	i += (*s++) & HASHMASK;
	if (*s) i+=(*s++ & HASHMASK)<<HASHIFT;
    }
    return i%HASHSIZE;
}

void ithash()
{
    int i;

    shead=NULL;				/* link chain is empty */

    hashtab=(SYMBOL **) xalloc(sizeof(SYMBOL *) * HASHSIZE);
    hashlength=(int *) xalloc(sizeof(int) * HASHSIZE);

    for (i=0;i<HASHSIZE;i++) {
	hashtab[i]=NULL;
	hashlength[i]=0;
    }
}

void fnhash()
{
    xfree((char *)hashtab);
    xfree((char *)hashlength);
}

