/* Yardtx.c	03-Nov-86	Read transitions for lookahead */
/* 25-Jul-87 IBM */
/* 30-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	rdtx()

	Statics:	[dptx(),dpdread() - TRACE]
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

void
rdtx()				/* Read transitions */
{
    void dpdread(),dptx();

    int v1,v2,v3;
    int sym,st,i,swap;

    message("rdtx:");

    ftrans=xopen(ntrans,READ_BINARY);

    trace(("rdtx: allocating ntxtab size cnntx %u * size %u = %u\n",
	cnntx,sizeof(NTXTAB),cnntx*sizeof(NTXTAB)));
    ntxtab=(NTXTAB *)xalloc(cnntx*sizeof(NTXTAB));
    trace(("rdtx: allocating dread size cnstate %u * size %u = %u\n",
	cnstate,sizeof(BITSTR *),cnstate*sizeof(BITSTR *)));
    dread=(BITSTR **)xalloc(cnstate*sizeof(BITSTR *));
    trace(("rdtx: allocating cnstate %u bit vectors length cntok %u\n",
	cnstate,cntok));
    for (i=0; i<cnstate; ++i) {		/* dread is indexed by state */
	dread[i]=alcbit(cntok);		/* bit vector is indexed by token */
	zerobit(dread[i],cntok);
    }

    st=-1;
    sym=-1;
    i=0;
    for (;;) {
	if ((v1=getw(ftrans)) == -1) {	/* Symbol */
	    break;			/* Eof indicator */
	}
	v2=getw(ftrans);		/* From state (sorted on this) */
	v3=getw(ftrans);		/* To state */
	(void)getw(ftrans);		/* Ignore rule */
	(void)getw(ftrans);		/* Ignore dposn */

	if (sym == v1 && st == v2) {	/* Ignore additional entries (rules) */
					/* Don't need to check to state */
	    trace(("rdtx: ignore (to is %u)\n",v3));
	    continue;
	}
	sym=v1;
	st=v2;

	if (isnont(v1)) {
	    trace(("rdtx: nont tx on %s from %u to %u\n",namesym(v1),v2,v3));
	    ntxtab[i].nont=valnont(v1);	/* ie. file contains symbol not nont */
	    ntxtab[i].from=v2;
	    ntxtab[i].to=v3;
	    ++i;
	}
	else {				/* Dread=Token transition from state */
	    trace(("rdtx: token tx on %s from %u to %u\n",namesym(v1),v2,v3));
	    setbit(dread[v2],valtok(v1));
	}
    }

    xclose(ftrans,ntrans);

#ifdef TRACE
    dptx();
    dpdread();
#endif
}

#ifdef TRACE

static void
dptx()
{
    int i,st;

    for (i=0; i<cnntx; ++i) {
	printf("ntx on %s from %u to %u\n",
	     namenont(ntxtab[i].nont),ntxtab[i].from,ntxtab[i].to);
    }
}

static void
dpdread()
{
    int i,j;

    for (j=0; j<cnstate; ++j) {
	printf("state %u dread ",j);
	for (i=0; i<sizebit(cntok) ; ++i) {
	    printf("%04x",dread[j][i]);
	}
	printf("  ");
	for (i=0; i<cntok; ++i) {
	    if (isbit(dread[j],i)) {
		printf("%s ",nametok(i));
	    }
	}
	printf("\n");
    }
}

#endif

