/* Yainit1.c	15-Jan-87 */
/* 20-Jul-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 08-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	init1()		fini1()

	Statics:	ecopy()		argparse()	maketname()
			makesname()

	Uses:		ithash()	opsym()		ophead()
			fnhash()	nxtchar()	flinenum()
*/

#include <stdio.h>

#define PHASE1

#include "yadefs.h"

#ifdef MINIX
#include <ctype.h>
#endif

void
init1(argc,argv)
int argc;
char *argv[];
{
    void argparse(),maketname(),makesname(),ithash();

    /* no message("init1:") because -g option not set yet */

    argparse(argc,argv);

    message("init1:");

    maketname();
    makesname();

    if (o_inname) {
	finput=xopen(o_inname,"r");
    }
    else {
	finput=stdin;
    }
    fytabc=xopen(nytabc,"w");		/* MUST be done before itlex() */
					/* hence can't be opened by parser */
					/* (lex lookahead may output to file)*/
    fprintf(fytabc,"/* %s */\n\n",VERSION);
    if (o_define) {			/* Because it may be used by */
	fytabh=xopen(nytabh,"w");	/* yylex() & opsym() & ophead() */
	fprintf(fytabh,"/* %s */\n\n",VERSION);
    }


    ithash();
    cnwarning=cnfatal=0;
}

void
fini1()
{
    void opsym(),ophead(),ecopy(),fnhash(),flinenum();

    message("fini1:");

    xclose(faction,naction);

    opsym();		/* token defines BEFORE tail */
    ophead();		/* miscellaneous defines */

    flinenum(fytabc);
    ecopy(fytabc);

    xclose(fytabc,nytabc);

    if (o_define) {
	xclose(fytabh,nytabh);
    }

    if (o_inname) {
	xclose(finput,o_inname);
    }

    fnhash();
}

static void
ecopy(f)
FILE *f;
{
    void nxtchar();

    while (ch != EOF) {
	putc(ch,f);
	nxtchar();
    }
}

static void
argparse(argc,argv)			/* Get command line args */
int argc;
char *argv[];
{
    int err;
    char *s;

    o_listall=o_define=o_yydebug=o_verbose=o_debug=0;
    o_linenum=1;
    o_inname=NULL;
    err=0;
    while (--argc && !err) {		/* Ignore arg0 */
	s= *++argv;			/* "= *" avoids old assignment op */
	if (*s++ == '-') {
	    while (*s) {
		switch (_toupper(*s++)) {
		    case '-':	break;
		    case 'D':	o_define=1; break;
		    case 'L':	o_linenum=0; break;
		    case 'T':	o_yydebug=1; break;
		    case 'V':	o_verbose=1; break;
		    case 'A':	o_listall=1; break;
		    case 'G':	o_debug=1; break;
		    case 'H':	/* fall thru for help */
		    default:	err=1;
		}
	    }
	}
	else {
	    if (o_inname) {
		err=1;
	    }
	    else {
		o_inname= *argv;
	    }
	}
    }
    if (err) {
	fprintf(stderr,"%s %s\n(%s code,%s data,%u bit strings)\n\n",
		VERSION,SYSTEM,CODEMODEL,DATAMODEL,BITLNG);
	fprintf(stderr,"Usage:  %syacc -dvatlgh [file]\n",PREAMBLE);
	fprintf(stderr,"Where:  -d send definition to %s\n",nytabh);
	fprintf(stderr,"        -v send parser,conflicts & statistics to %s\n",
					noutput);
	fprintf(stderr,"        -a list ALL conflicts, even if resolved\n");
	fprintf(stderr,"        -t debugging is activated by default\n");
	fprintf(stderr,"        -l do not output #line constructs\n");
	fprintf(stderr,"        -g describe yacc's progress on stdout\n");
	fprintf(stderr,"        -h help - this message\n");
	fprintf(stderr,"Input:  comes from stdin (which may be redirected)\n");
	fprintf(stderr,"        or file if explicitly specified\n");
	fprintf(stderr,"Output: goes to %s\n",nytabc);
	fprintf(stderr,"Errors: go to stderr, as do conflicts unless -v\n");
	exit(1);
    }
}

void
maketname()		/* make names for temporary files */
{
    char *tmppath;
    unsigned lenv;

#ifdef SKELENVPATH
    if ((tmppath=getenv(TMPENVPATH)) == NULL) {
#else
    {
#endif
	tmppath=strcpy(malloc(strlen(TMPDEFPATH)+1),TMPDEFPATH);
    }
    if (strlen(tmppath)) {	/* don't add slash unless path exists */
	strcat(
	    strcpy((g_tmppath=malloc(strlen(tmppath)+2)),tmppath)
	    ,PATHSEPARATOR);
	free(tmppath);
    }
    else {
	g_tmppath=tmppath;
    }
    lenv=strlen(g_tmppath);

    strcat(
	strcpy(
	    (naction=malloc(lenv+strlen(tnaction)+1))
	     ,g_tmppath)
	,tnaction);
    strcat(
	strcpy(
	    (nstring=malloc(lenv+strlen(tnstring)+1))
	     ,g_tmppath)
	,tnstring);
    strcat(
	strcpy(
	    (nsymbol=malloc(lenv+strlen(tnsymbol)+1))
	     ,g_tmppath)
	,tnsymbol);
    strcat(
	strcpy(
	    (nrule=malloc(lenv+strlen(tnrule)+1))
	     ,g_tmppath)
	,tnrule);
    strcat(
	strcpy(
	    (nrhs=malloc(lenv+strlen(tnrhs)+1))
	     ,g_tmppath)
	,tnrhs);
    strcat(
	strcpy(
	    (nitem=malloc(lenv+strlen(tnitem)+1))
	     ,g_tmppath)
	,tnitem);
    strcat(
	strcpy(
	    (ngoto=malloc(lenv+strlen(tngoto)+1))
	     ,g_tmppath)
	,tngoto);
    strcat(
	strcpy(
	    (nshift=malloc(lenv+strlen(tnshift)+1))
	     ,g_tmppath)
	,tnshift);
    strcat(
	strcpy(
	    (ntr2=malloc(lenv+strlen(tntr2)+1))
	     ,g_tmppath)
	,tntr2);
    strcat(
	strcpy(
	    (ntrans=malloc(lenv+strlen(tntrans)+1))
	     ,g_tmppath)
	,tntrans);

#ifdef TRACE
    printf("maketname: %s\n",naction);
    printf("maketname: %s\n",nstring);
    printf("maketname: %s\n",nsymbol);
    printf("maketname: %s\n",nrule);
    printf("maketname: %s\n",nrhs);
    printf("maketname: %s\n",nitem);
    printf("maketname: %s\n",ngoto);
    printf("maketname: %s\n",nshift);
    printf("maketname: %s\n",ntr2);
    printf("maketname: %s\n",ntrans);
#endif
}

void
makesname()		/* make name for parser skeleton file */
{
    char *skelpath,*workpath;
    unsigned lenv;

#ifdef SKELENVPATH
    if ((workpath=getenv(SKELENVPATH)) == NULL) {
#else
    {
#endif
	workpath=strcpy(malloc(strlen(SKELDEFPATH)+1),SKELDEFPATH);
    }
    if (strlen(workpath)) {	/* don't add slash unless path exists */
	strcat(
	    strcpy((skelpath=malloc(strlen(workpath)+2)),workpath)
	    ,PATHSEPARATOR);
	free(workpath);
    }
    else {
	skelpath=workpath;
    }
    lenv=strlen(skelpath);

    strcat(
	strcpy(
	    (nyaccpar=malloc(lenv+strlen(SKELDEFNAME)+1))
	     ,skelpath)
	,SKELDEFNAME);

#ifdef TRACE
    printf("makesname: %s\n",nyaccpar);
    exit(1);
#endif
}

