/* Yagoto.c 15-Dec-86	Make goto file from sorted nonterminal transitions */
/* 25-Jul-87 IBM */
/* 30-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	mkgoto()

	Statics:	gcmp()

	Uses:		qsort()
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

void
mkgoto()
{
    void qsort();
    int gcmp();
    int i;

    message("mkgoto:");

    fgoto=xopen(ngoto,WRITE_BINARY);

    trace(("mkgoto: cnntx=%d sizeof(NTXTAB)=%d *=%d\n",
	cnntx,sizeof(NTXTAB),cnntx*sizeof(NTXTAB) ));

#ifdef TRACE
    for (i=0; i<cnntx; ++i) {
	trace(("mkgoto:ntxtab[i] from %u\tto %u\t nont %u\t%s\n",
	ntxtab[i].from,ntxtab[i].to,ntxtab[i].nont,namenont(ntxtab[i].nont)));
    }
#endif

    qsort(ntxtab,cnntx,sizeof(NTXTAB),gcmp);

    for (i=0; i<cnntx; ++i) {
	trace(("goto: on %s\tfrom %d to %d\n",
		namenont(ntxtab[i].nont),ntxtab[i].from,ntxtab[i].to));
	putw(ntxtab[i].nont,fgoto);	/* Output real value */
	putw(ntxtab[i].from,fgoto);
	putw(ntxtab[i].to,fgoto);
    }
    putw(-1,fgoto);
    xclose(fgoto,ngoto);
}

static int			/* Ascending order on nont */
gcmp(a,b)
NTXTAB *a,*b;
{
    int i;

    i=a->nont-b->nont;
#ifdef TRACE
    printf("gcmp: %s (%u) - %s (%u) = %u\n",namenont(a->nont),a->nont,
	namenont(b->nont),b->nont,i);
#endif
    return i;
}

