/* Yafunc.c	21-Jan-87	Parser functions used in defs,rules & tail */
/* 25-Jul-87 IBM */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	settok()	setnont()	addlist()
			addrule()
*/

#include <stdio.h>

#define PHASE1

#include "yadefs.h"

void
settok(sym,toknum)
SYMBOL *sym;
int toknum;
{
    if (sym->kind == NONE) {
	sym->kind=TOKEN;
	sym->assoc=NONE;
	sym->prec=0;
	sym->type=NOTYPE;
	sym->toknum=(toknum == NOTOKEN) ? bsnont++ : toknum;
	++cntok;
    }
    else {
	if (sym->kind == TOKEN) {
	    if (toknum != NOTOKEN && sym->toknum != toknum) {
		errmsg("Can't redefine token number",FATAL);
	    }
	}
	else {
	    errmsg("Can't redeclare symbol as token",FATAL);
	}
    }
}

void
setnont(sym)
SYMBOL *sym;
{
    if (sym->kind == NONE) {
	sym->kind=NONT;
	sym->type=NOTYPE;
	sym->rule=NULL;
	++cnnont;
    }
    else {
	if (sym->kind != NONT) {
	    errmsg("Can't redeclare symbol as nonterminal",FATAL);
	}
    }
}

void
addlist(rule,sym)
RULE *rule;
SYMBOL *sym;
{
    LIST *list,*last;

    list=(LIST *)xalloc(sizeof(LIST));
    ++cnrhs;				/* Track number of symbols in lists */
    list->sym=sym;
    list->next=NULL;

    last=rule->list;
    while (last && last->next) {
	last=last->next;
    }

    if (last) {				/* Link to end of list */
	last->next=list;
    }
    else {			/* First entry, so head of list */
	rule->list=list;
    }
}

RULE *addrule()
{
    RULE *rule;

    rule=(RULE *)xalloc(sizeof(RULE));
    rule->list=NULL;			/* Empty right side */
    rule->prec=NULL;			/* No precedence is default */
					/* sym,seq,next filled in later */
    return rule;
}

