/* Yafirst.c	29-Oct-86	Compute nullable and first for nonterminals */
/* 25-Jul-87 IBM */
/* 09-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	frfirst()	mkfirst()

	Statics:	[dpfirst(),dpnbit() - TRACE]
*/

#include <stdio.h>

#define	PHASE2

#include "yadefs.h"

void
frfirst()
{
    int n;

    message("frfirst:");

    for (n=0; n <cnnont; ++n) {
	xfree((char *)first[n]);
    }
    xfree((char *)first);
}

void
mkfirst()
{
#ifdef TRACE
    void dpnbit(),dpfirst();
#endif
    int added;
    int i,n,n2,r;

    message("mkfirst:");

    nullable=alcbit(cnnont);
    zerobit(nullable,cnnont);

    first=(BITSTR **)xalloc(cnnont*sizeof(BITSTR *));
    for (n=0; n <cnnont; ++n) {
	first[n]=alcbit(cnnont);
	zerobit(first[n],cnnont);
	setbit(first[n],n);		/* Nont is in its own first list */
    }

    do {				/* Iterative for transitive closure */
	trace(("mkfirst: iteration\n"));
#ifdef TRACE
	dpfirst();
#endif /* TRACE */

	added=0;
	for (n=0; n < cnnont; ++n) {			/* For all nont */
	    for (r=nontrule[n]; r<nontrule[n+1]; ++r) {	/* For all its rules */
		i=rulerhs[r];				/* For FIRST rhs sym */
		if (i < rulerhs[r+1] &&			/* Rule not empty */
			rhs[i] >= cntok) {		/* Nont */
		    n2=rhs[i]-cntok;
		    if (!isbit(first[n],n2)) {
			trace(("mkfirst: Before adding %s to first %s\n",
				namenont(n2),namenont(n)));
#ifdef TRACE
			dpnbit(first[n]);
#endif
			setbit(first[n],n2);
			++added;
			trace(("mkfirst: After adding %s to first %s\n",
				namenont(n2),namenont(n)));
#ifdef TRACE
			dpnbit(first[n]);
#endif
		    }

		    /* Merge first lists regardless - rhs may already be in */
		    /* first list but its own first list may have changed */

		    added+=orbit(first[n],first[n2],cnnont);
		}
	    }
	}
    } while (added);

    do {
	added=0;
	for (n=0; n < cnnont; ++n) {			/* For all nont */
	    for (r=nontrule[n]; r<nontrule[n+1]; ++r) {	/* For all its rules */
		i=rulerhs[r];				/* For each rhs sym */
		while (i < rulerhs[r+1] &&		/* Not yet at end */
		       rhs[i] >= cntok  &&		/* And nont */
		       isbit(nullable,rhs[i]-cntok)) {	/* Which is nullable */
 			    ++i;			/* Look at next rhs */
		}

		if (i == rulerhs[r+1]) {	/* End, so whole rhs =>empty */
		    if (!isbit(nullable,n)) {
			setbit(nullable,n);
			++added;
			trace(("mkfirst: Setting nullable %s\n",namenont(n)));
		    }
		}
	    }
	}
     } while (added);

#ifdef TRACE
    dpfirst();
#endif /* TRACE */
}

#ifdef TRACE
static void
dpfirst()
{
    void dpnbit();
    int n;

    printf("Nullable =>");
    dpnbit(nullable);

    for (n=0; n < cnnont; ++n) {			/* For all nont */
	printf("%s first => ",namenont(n));
	dpnbit(first[n]);
    }
}

static void
dpnbit(s)
BITSTR *s;
{
    int i;

    for (i=0; i<sizebit(cnnont) ; ++i) {
	printf("%04x",s[i]);
    }
    printf("  ");
    for (i=0; i<cnnont; ++i) {
	if (isbit(s,i)) {
	    printf("%s ",strarea+nontstr[i]);
	}
    }
    printf("\n");
}

#endif /* TRACE */

