/* Yadefs.h	15-Oct-86 */
/* 01-Aug-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 07-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

#include "yavers.h"

#include "yasystem.h"

#ifdef STDLIBHEAD
#include STDLIBHEAD
#endif

#ifdef STRINGHEAD
#include STRINGHEAD
#endif

#define DATAMODEL ( sizeof(char *) > 2 ? "large" : "small" )
#define CODEMODEL ( sizeof(char (*)()) > 2 ? "large" : "small" )

#ifdef	PLINKII
#define PREAMBLE "run "			/* Used by usage message on init */
#else
#define PREAMBLE ""
#endif

/*
#define	BITMACRO
*/

#ifdef	TRACE				/* Strip off outer parentheses */
#define	trace(x)	printf x
#else
#define	trace(x)
#endif	/* TRACE */

#ifdef	DEFINE
#define DEFMAC
#else
#define	DEFMAC	extern
#endif	/* DEFINE */

#define	DEF0	extern		/* Phase0 declarations visible to all phases */

#ifdef	DEFINE
#ifdef	PHASE0
#undef	DEF0
#define	DEF0			/* But only define in phase 0 itself */
#endif	/* PHASE0 */
#endif	/* DEFINE */

/*		****** PHASE0 ****** ****** PHASE0 ******		*/

/*			****** Bitmap Stuff ******			*/

#define BITBYTE	sizeof(BITSTR)	/* Length in bytes of BITSTR */
#define BITLNG	(BITBYTE * 8)	/* Length in bits of BITSTR */

#ifdef	BITMACRO

#define	isbit(s,n)	( ((s)[(n) / BITLNG]) &  (1 << ((n) % BITLNG)) )
#define setbit(s,n)	( ((s)[(n) / BITLNG]) |= (1 << ((n) % BITLNG)) )
#define clrbit(s,n)	( ((s)[(n) / BITLNG]) &= ~(1 << ((n) % BITLNG)) )
#define	sizebit(n)	( (n-1)/BITLNG+1 )
#define alcbit(n)	( (BITSTR *)xalloc(sizebit(n)*BITBYTE) )

#else

int isbit();
void setbit();
void clrbit();
int sizebit();
BITSTR *alcbit();

#endif

void zerobit();
int orbit();
int andbit();
int eqbit();
void copybit();

/*		****** Variously used constants ******			*/

#define	ABORT	1
#define	FATAL	2
#define	WARNING	3

#define NONE		1
#define TOKEN		2
#define	LEFT		3
#define	RIGHT		4
#define	NONASSOC	5
#define TYPE		6
#define	NONT		7

#define FIRSTTOKEN	256		/* First non-literal token */
#define	ENDTOKEN	0		/* Endmarker */

#define TABLEWIDTH	10		/* Width of ytab.c tables */

#define	YXFLAG		-1000		/* Empty entry in yxact[] */

/*		***** Declare file names and handles *****		*/

#define	nytabh		YTABHDEFNAME
#define	nytabc		YTABCDEFNAME
#define noutput		YOUTDEFNAME
#define tnaction	"yaction.$$$"
#define tnstring	"ystring.$$$"
#define	tnsymbol	"ysymbol.$$$"
#define tnrule		"yrule.$$$"
#define	tnrhs		"yrhs.$$$"
#define tnitem		"yitem.$$$"
#define tngoto		"ygoto.$$$"
#define tnshift		"yshift.$$$"
#define tntr2		"ytr2.$$$"
#define tntrans		"ytrans.$$$"

/* 		****** function return values ******			*/

char *xalloc();
char *xrealloc();
void xfree();
void errmsg();
void bug();
void where();
char *itoa();
FILE *xopen();
void xclose();

/* 		****** Storage declaration/definition ******		*/

DEF0 int	o_verbose;	/* Option - generate youtput */
DEF0 int	o_define;	/* Option - copy definitions to ytabh */
DEF0 int	o_debug;	/* Option - describe what yacc is doing */
DEF0 int	o_yydebug;	/* Option - debugging on is default */
DEF0 int	o_linenum;	/* Option - include line numbers in output */
DEF0 int	o_listall;	/* Option - list resolved conflicts as well */
DEF0 char	*o_inname;	/* Option - input file name (NULL -> stdin) */

/* Declare pointers to names of temporary files (dynamically allocated) */

DEF0 char *nyaccpar;
DEF0 char *naction;
DEF0 char *nstring;
DEF0 char *nsymbol;
DEF0 char *nrule;
DEF0 char *nrhs;
DEF0 char *nitem;
DEF0 char *ngoto;
DEF0 char *nshift;
DEF0 char *ntr2;
DEF0 char *ntrans;

DEF0 char *g_tmppath;		/* Temporary file path */

DEF0 FILE	*finput,	/* Yacc input file containing grammar */
		*fyaccpar,	/* Yacc input model parser */
		*fytabh,	/* Yacc output definitions (for lex) */
		*fytabc,	/* Yacc output (parser,tables,actions) */
		*foutput,	/* Yacc output verbose description */
		*faction,	/* Temporary - actions */
		*fstring,	/* Temporary - strings */
		*fsymbol,	/* Temporary - symbols */
		*frule,		/* Temporary - rules */
		*frhs,		/* Temporary - rule rhs */
		*fitem,		/* Temporary - items */
		*fshift,	/* Temporary - shift entries */
		*fgoto,		/* Temporary - goto entries */
		*ftr2,		/* Temporary - transitions sorted by rule */
		*ftrans;	/* Temporary - transitions */

DEF0 int cnwarning;		/* Count of warnings in input */
DEF0 int cnfatal;		/* Count of fatal errors in input */
DEF0 int cnstr;			/* Size of string area */
DEF0 int cnrule;		/* Number of rules */
DEF0 int cnrhs;			/* Number of symbols in rhs of rules */
DEF0 int cnnont;		/* Number of non-terminals */
DEF0 int cntok;			/* Number of tokens (literal & non-literal) */
DEF0 int bstok;			/* 1st value for non-literal tokens */
DEF0 int bsnont;		/* 1st value for non-terminals */

DEF0 int start;			/* Symbol sequence number of start nont */

DEF0 int cnstate;		/* Count of states */
DEF0 int cnitem;		/* Count of items */
DEF0 int cnincon;		/* Count of inconsistent items in states */
DEF0 int cncxst;		/* Count of complex states */
DEF0 int cncxit;		/* Count of complete items in complex states */
DEF0 int cnntx;			/* Count of nonterminal transitions */
DEF0 int cnttx;			/* Count of token transitions */
DEF0 int cnrtx;			/* Count of transitions with rules in file */
DEF0 int cnshift;		/* Count of shift entries */
DEF0 int cngo;			/* Count of goto entries */

typedef struct ntxtab {
    int nont;			/* Transition on nonterminal */
    int from;			/* From state */
    int to;			/* To state */
} NTXTAB;

DEF0 NTXTAB *ntxtab;		/* Table of nonterminal transitions */
				/* NB. table of entries NOT pointers */

DEF0 BITSTR **incl;		/* Table indexed by ntx of includes relation */
				/* Of lists of ntx */
DEF0 BITSTR **lback;		/* Table indexed by inconsistent item */
				/* Of lists of ntx in lookback relation */

DEF0 BITSTR **dread;		/* Table indexed by state of direct reads */
				/* Vector indexed by tokens */

DEF0 int *ist;			/* Inconsistent complete items - state */
DEF0 int *ilhs;			/* Inconsistent complete items - lhs nont */
DEF0 int *irule;		/* Inconsistent complete items - rule */
DEF0 BITSTR **ila;		/* Inconsistent complete items - lookahead */
				/* (vector indexed by tokens) */

#ifdef CPM
#define DISTACKSIZE	50
#else
#define DISTACKSIZE	200
#endif

#define INFINITY	DISTACKSIZE+1	/* Doen't need to be greater */
					/* Musn't be negative on int compare */

DEF0 BITSTR **work;		/* Array indexed by ntx of work vectors */
				/* for lookahead. Vector indexed by token */
				/* Contains either "reads" or "follows" */

DEF0 int dmax,			/* Length of din */
	 *din,			/* Array used by traverse */
	 *stack,		/* Stack used by traverse */
	 *sp,			/* Stack pointer (empty=stack-1) */
	 depth;			/* Stack depth (empty=0) */


DEF0 void (*dicopy)();		/* Function to copy vector */
DEF0 void (*diunion)();		/* Function to union two vectors */
DEF0 int  (*direln)();		/* Function to return relation */


/*		****** PHASE1 ****** ****** PHASE1 ******		*/

#ifdef	PHASE1

#define	PROMPT	".."		/* Prompt tty for input */

#define	ENDSTR	"\032"		/* End of file as a string !!! */
				/* (Used to ccopy() until EOF) */

#define DEFINITIONS	0	/* Values for section */
#define	RULES		1	/* (Communicate between parser and lex) */
#define	TAIL		2

#define	BUFLNG	256			/* Lexical analyzer buffer */

#define	STACKSIZE	128		/* Parser stack length */

#define HASHSIZE  141			/* should be prime */
#define HASHIFT 4
#define HASHMASK 0x1f

/*		****** Values for toknum ******				*/

#define	NOTOKEN		-1		/* Value used when no token specd */

#define	ENDNAME		"$end"		/* Name of endmarker */
#define	ACCEPTNAME	"$accept"	/* Name of accept symbol */
#define	ERRORNAME	"error"		/* Name of error symbol */

#define NOTYPE		NULL		/* Value used when no union type */

/* 		****** Data structure definitions ******		*/

typedef struct symbol {			/* symbol table entry */
    char *name;				/* description (string) */
    struct symbol *lsym;		/* next symbol in link chain */
    char kind;				/* TOKEN,NONT */
    char assoc;				/* NONE,LEFT,RIGHT,NONASSOC */
    int prec;				/* 0 = none */
    int toknum;				/* 0=EOF,1-256=literal,>256=rest */
    char *type;				/* Union type (NOTYPE=none) */
    struct rule *rule;			/* Rule list for nont(NULL=none) */
} SYMBOL;

typedef struct rule {			/* Rule list entry */
    struct symbol *sym;			/* LHS nonterminal */
    int prec;				/* Precedence */
    int seq;				/* Sequence number */
    struct list *list;			/* List of RHS symbols */
    struct rule *next;			/* Next rule in list */
} RULE;

typedef struct list {			/* List of symbols */
    struct symbol *sym;
    struct list *next;
} LIST;

/* 		****** Storage declaration/definition ******		*/

DEFMAC SYMBOL *mx_send;			/* Define end marker */
DEFMAC SYMBOL *sstart;			/* Define start symbol */
DEFMAC SYMBOL *shead;			/* Head of thread thru symbols */

DEFMAC int ch;				/* Nxtchar() read */

DEFMAC int section;			/* Set by parser routines */
DEFMAC int nextrule;			/* Sequence number to be used by */
					/* nextrule - used as case number of */
					/* action as well */
DEFMAC int g_offset;			/* Offset of element from beginning */
					/* of rule being parsed */
					/* (0 = before 1st element) */

DEFMAC SYMBOL *g_cid;			/* Left nont of rule being parsed */
DEFMAC RULE *g_rule;			/* Rule being parsed */

DEFMAC int g_typeon;			/* Type checking has been activated */

DEFMAC int curprec;			/* Used by parser routines */
DEFMAC char *curtype;
DEFMAC int command;

#endif	/* PHASE1 */

#ifdef	PHASE2

/* 		****** Data structure definitions ******		*/

typedef struct state {			/* State list entry */
    int num;				/* Unique sequence number for state */
    struct item *item;			/* Head of item list of this state */
    struct item *empty;			/* List of empty items in closure */
    struct state *next;
} STATE;

typedef struct item {			/* Item list entry */
    int rule;				/* Index to rule table */
    int dposn;				/* Distinguished position */
					/* (0=complete,1=before 1st symbol) */
    struct item *next;
} ITEM;

typedef struct trans {			/* Transition list entry */
    int sym;				/* Sequence number of symbol */
    struct item *item;			/* Item list to go to */
    struct trans *next;
} TRANS;

/*		****** Macro definitions ******			*/

#define	iscomplete(it)	( (it)->dposn == 0 )
#define	rhssym(it,i)	( rhs[rulerhs[(it)->rule]+i-1] )
#define	dsym(it)	( rhssym((it),(it)->dposn) )

#define	lngrule(rule)	( rulerhs[(rule)+1] - rulerhs[(rule)] )

#define	istok(sym)	( (sym) < cntok )
#define	valtok(sym)	( sym )
#define	isnont(sym)	( (sym) >= cntok )
#define	valnont(sym)	( (sym) - cntok )
#define	namenont(nont)	( strarea + nontstr[(nont)] )
#define	nametok(tok)	( strarea + tokstr[(tok)] )
#define	namesym(sym)	( isnont(sym) ? namenont((sym)-cntok) : nametok(sym) )

/* 		****** Storage declaration/definition ******		*/

DEFMAC BITSTR *nullable;	/* Bit string of nullable nont */
DEFMAC BITSTR **first;		/* Array of first bit strings for nont */

DEFMAC char *strarea;
DEFMAC int *tokstr;
DEFMAC int *toknum;
DEFMAC int *tokprec;
DEFMAC int *tokassoc;
DEFMAC int *nontstr;
DEFMAC int *nontrule;
DEFMAC int *rulesym;
DEFMAC int *ruleseq;
DEFMAC int *ruleprec;
DEFMAC int *rulerhs;
DEFMAC int *rhs;

#endif	/* PHASE2 */

