# Makefile for PGP (Watcom C 11.0)
# Contributed by "Georg Bauer" <gb@hugo.westfalen.de>
#
#
RSAOBJS = rsaglue.obj

DEFINES  = -DNO_ASM -DPORTABLE -DMSDOS -DDYN_ALLOC -DSMALL_MEM $(RSAOPTS)
ADEFINES = -DDYN_ALLOC -DSS_NEQ_DS

CC      = wcl /bt=dos

# Decide between speed (the first one) and size (the second one).
# Using the size-options gives you about 20K additional Ram.
# If you change the /0 to /5, the excecutable will run on 386 and up
# and use commands of the newer CPUs. If you change it to /1, it will
# just use 80186 commands, notably enter and leave.
OPT     = /zq /zc /zt1024 /ml /oneatx /zp8 /5 /oh /ei /fpc
#OPT    = /zq /zc /zt1024 /ml /os /zp1 /0 /fpc

CFLAGS  = /c $(OPT) $(DEFINES)
LD      = wcl          # Link command
LDFLAGS = /k32000 /bt=dos

ASM     = wasm          # Assembler command
AFLAGS  = -ml $(ADEFINES)
# For MASM 6.0, use the following
#ASM    = ml -nologo
#AFLAGS = -Zm -Cp -c $(ADEFINES)

#OBJS_EXT= 8086.obj zmatch.obj   # ASM obj. files
LIBS_EXT=                        # Libararies

PROJ    =pgp
EXT     =.exe

PGPLIB  =pgplib.lib

..c.obj:
        $(CC) $(CFLAGS) $(DEBUG) $*.c

all:    .SYMBOLIC $(PROJ)$(EXT)

clean: .SYMBOLIC
        del $(PROJ)$(EXT)
        del $(PGPLIB)
        del *.obj

scratch: .SYMBOLIC clean all

new:     .SYMBOLIC clean all


# Assembly-language subroutine dependencies

8086.obj: 8086.asm
        $(ASM) $(AFLAGS) 8086.asm

zmatch.obj: zmatch.asm
        $(ASM) $(AFLAGS) $(ADEFINES) zmatch.asm

ZIPOBJS= zbits.obj zdeflate.obj zfile_io.obj zglobals.obj zinflate.obj zip.obj zipup.obj ztrees.obj zunzip.obj

OBJ1    = pgp.obj crypto.obj keymgmt.obj fileio.obj mdfile.obj more.obj
OBJ2    = armor.obj mpilib.obj mpiio.obj genprime.obj rsagen.obj random.obj
OBJ3    = idea.obj passwd.obj md5.obj system.obj language.obj getopt.obj
OBJ4    = keyadd.obj config.obj keymaint.obj charset.obj
OBJ5    = $(OBJS_EXT) $(RSAOBJS)

$(PGPLIB): $(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4) $(OBJ5) $(ZIPOBJS)
        if exist $(PGPLIB) del $(PGPLIB)
        if exist pgplib.rsp del pgplib.rsp
        for %i in ($(OBJ1)) do echo +%i >>pgplib.rsp
        for %i in ($(OBJ2)) do echo +%i >>pgplib.rsp
        for %i in ($(OBJ3)) do echo +%i >>pgplib.rsp
        for %i in ($(OBJ4)) do echo +%i >>pgplib.rsp
        for %i in ($(OBJ5)) do echo +%i >>pgplib.rsp
        for %i in ($(ZIPOBJS)) do echo +%i >>pgplib.rsp
        wlib $(PGPLIB) @pgplib.rsp

$(PROJ)$(EXT):  $(PGPLIB)
        $(LD) $(LDFLAGS) pgp.obj $(PGPLIB)

## Dependencies ##
armor.obj: armor.c mpilib.h usuals.h platform.h fileio.h mpiio.h language.h
armor.obj: pgp.h more.h armor.h crypto.h charset.h
charset.obj: charset.c usuals.h language.h charset.h system.h
config.obj: config.c usuals.h fileio.h pgp.h more.h armor.h config.h charset.h
crypto.obj: crypto.c mpilib.h usuals.h platform.h mpiio.h random.h idea.h
crypto.obj: crypto.h keymgmt.h keymaint.h pgp.h more.h armor.h mdfile.h md5.h
crypto.obj: fileio.h charset.h language.h exitpgp.h zipup.h rsaglue.h
fileio.obj: fileio.c random.h usuals.h mpilib.h platform.h mpiio.h fileio.h
fileio.obj: language.h pgp.h more.h armor.h exitpgp.h charset.h system.h idea.h
genprime.obj: genprime.c mpilib.h usuals.h platform.h genprime.h random.h idea.h
getopt.obj: getopt.c getopt.h
idea.obj: idea.c idea.h usuals.h
keyadd.obj: keyadd.c mpilib.h usuals.h platform.h crypto.h fileio.h keymgmt.h
keyadd.obj: charset.h language.h pgp.h more.h armor.h exitpgp.h keyadd.h
keyadd.obj: keymaint.h keymaint.c mpilib.h usuals.h platform.h random.h idea.h
keymaint.obj: crypto.h fileio.h keymgmt.h keymaint.h pgp.h more.h armor.h
keymaint.obj: mpiio.h charset.h language.h mpilib.h
keymgmt.obj: keymgmt.c system.h mpilib.h usuals.h platform.h idea.h random.h
keymgmt.obj: crypto.h fileio.h keymgmt.h rsagen.h mpiio.h language.h pgp.h
keymgmt.obj: more.h armor.h md5.h charset.h keymaint.h
language.obj: language.c usuals.h fileio.h language.h pgp.h more.h armor.h
language.obj: charset.h
md5.obj: md5.c md5.h
mdfile.obj: mdfile.c mpilib.h usuals.h platform.h mdfile.h md5.h fileio.h
mdfile.obj: language.h pgp.h more.h armor.h
more.obj: more.c mpilib.h usuals.h platform.h language.h fileio.h pgp.h more.h
more.obj: armor.h charset.h
mpiio.obj: mpiio.c mpilib.h usuals.h platform.h mpiio.h pgp.h more.h armor.h
mpilib.obj: mpilib.c mpilib.h usuals.h platform.h
passwd.obj: passwd.c random.h idea.h usuals.h md5.h language.h pgp.h more.h
passwd.obj: armor.h
pgp.obj: pgp.c system.h mpilib.h usuals.h platform.h random.h crypto.h fileio.h
pgp.obj: keymgmt.h language.h pgp.h more.h armor.h exitpgp.h charset.h getopt.h
pgp.obj: config.h keymaint.h keyadd.h rsaglue.h idea.h
r3000.obj: r3000.c mpilib.h usuals.h platform.h lmul.h
random.obj: random.c system.h idea.h usuals.h md5.h language.h random.h
random.obj: fileio.h pgp.h more.h armor.h
rsagen.obj: rsagen.c mpilib.h usuals.h platform.h genprime.h rsagen.h random.h
rsagen.obj: rsaglue.h idea.h
rsaglue.obj: rsaglue.c mpilib.h usuals.h platform.h mpiio.h pgp.h more.h
rsaglue.obj: armor.h rsaglue.h random.h idea.h
system.obj: system.c exitpgp.h system.h usuals.h mpilib.h
zbits.obj: zbits.c zip.h ztailor.h ziperr.h
zdeflate.obj: zdeflate.c zunzip.h usuals.h system.h zip.h ztailor.h ziperr.h
zfile_io.obj: zfile_io.c zunzip.h usuals.h system.h
zglobals.obj: zglobals.c zip.h ztailor.h ziperr.h
zinflate.obj: zinflate.c zunzip.h usuals.h system.h exitpgp.h
zip.obj: zip.c zip.h usuals.h fileio.h language.h pgp.h more.h armor.h
zip.obj: exitpgp.h ziperr.h
zipup.obj: zipup.c zip.h ztailor.h ziperr.h zrevisio.h
ztrees.obj: ztrees.c zip.h ztailor.h ziperr.h
zunzip.obj: zunzip.c zunzip.h usuals.h system.h language.h
