/*	IDEA Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

	LAYOUT & STRUCTURE  BASED ON THE CODE SAMPLE.CPP BY DILDOG

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/

#include <windows.h>
#include "plugins.h"
#include "bocomreg.h"
#include "iohandler.h"
#include "encryption.h"
#include "IDEAMain.hpp"

// Plugin Linkage Variables
CEncryptionHandler				*g_pEncHandler=NULL;
CIOHandler						*g_pIOHandler=NULL;
TYPEOF_RegisterCommand			*RegisterCommand=NULL;
TYPEOF_UnregisterCommand		*UnregisterCommand=NULL;
TYPEOF_RegisterClientMenu		*RegisterClientMenu=NULL;
TYPEOF_UnregisterClientMenu		*UnregisterClientMenu=NULL;
TYPEOF_IssueAuthCommandRequest	*IssueAuthCommandRequest=NULL;
TYPEOF_IssueAuthCommandReply	*IssueAuthCommandReply=NULL;
TYPEOF_ConnectAuthSocket		*ConnectAuthSocket=NULL;
TYPEOF_ListenAuthSocket			*ListenAuthSocket=NULL;
TYPEOF_InteractiveConnect		*InteractiveConnect=NULL;
TYPEOF_InteractiveListen		*InteractiveListen=NULL;

// Global variables
HINSTANCE g_hInstance;
int IDEAEngineNum;

// Configuration string read by client,server and configuration tool
extern char *g_szIDEAEncryptOptions;

// ------------- Function Implementations ------------------

BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	// Do NOT perform configuration or initialization here

	switch (ul_reason_for_call) {
	case DLL_PROCESS_ATTACH:
		g_hInstance=hInst;
		break;
	}
	return TRUE;
}

// InstallPlugin is called on both the server side and the client side to
// pass in function addresses that the plugin can use.
// Some functions are only passed in by the client, and some only by the
// server. If they are not passed, in they are NULL.

ENCRYPTION_ENGINE *GetIDEAEncryptionEngine(void);

BOOL InstallPlugin(PLUGIN_LINKAGE pl)
{
	g_pEncHandler=pl.pEncryptionHandler;
	g_pIOHandler=pl.pIOHandler;
	RegisterCommand=pl.pRegisterCommand;
	UnregisterCommand=pl.pUnregisterCommand;
	IssueAuthCommandRequest=pl.pIssueAuthCommandRequest;
	IssueAuthCommandReply=pl.pIssueAuthCommandReply;
	ConnectAuthSocket=pl.pConnectAuthSocket;
	ListenAuthSocket=pl.pListenAuthSocket;
	RegisterClientMenu=pl.pRegisterClientMenu;
	UnregisterClientMenu=pl.pUnregisterClientMenu;
	InteractiveListen=pl.pInteractiveListen;
	InteractiveConnect=pl.pInteractiveConnect;
	
	if (g_pEncHandler)
	{
		IDEAEngineNum = g_pEncHandler->Insert(GetIDEAEncryptionEngine());
		if (IDEAEngineNum==-1) return FALSE;
	}
	else return FALSE;

	return TRUE;
}

// TerminatePlugin should wait for all threads spawned by the client or server
// to terminate, because the plugin DLL will be unloaded after this returns.

void TerminatePlugin(void)
{
	if (g_pEncHandler)
	{
		g_pEncHandler->Remove(IDEAEngineNum);
	}
}

BOOL PluginVersion(PLUGIN_VERSION *ppv)
{
	ppv->svFilename="IDEAEncrypt.dll";
	ppv->svDescription="BO2K IDEA Encryption Engine";
	ppv->wVersionHi=1;
	ppv->wVersionLo=0;
	ppv->wBOVersionHi=1;
	ppv->wBOVersionLo=1;

	return TRUE;
}


