/* encrypt.c - Mark Henderson (markh@wimsey.bc.ca) */
#include <gmp.h>
#include "lucas.h"
#include "d3des.h"
#include "prandom.h"
#include <stdio.h>
#include "misc.h"

main(int argc,char *argv[])
{
    MP_INT *e,*n,*c;
    char pubfile[128]; int i;
    unsigned char key[32];
    unsigned char cipher[MAXC];
    FILE *public;
    init(e); init(n); init(c);
    if (argc < 2) {
        fprintf(stderr, "usage: encrypt pubfile\n");
        exit(1);
    }
    
    strncpy(pubfile,argv[1],120);
    strcat(pubfile,".pub");

    if (!(public = mfopen(pubfile, "rb"))) {
        fprintf(stderr, "could not open %s for read\n", pubfile);
        exit(1);
    }

    initrandom();
    fprintf(stderr, "please enter a random string -- end with <CR>\n");
    (void)getstring(0);
    for (i=0;i<32;i++)
        key[i] = randombyte();

    read_number(public,n);
    read_number(public,e);
    encrypt_session_key(c,key,n,e);
    write_number(stdout,c);
    desfile(stdin,stdout,&key[0], &key[24], EN0);
	zap(key,32);
}

