#line 559 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "piesctl-cl.opt"
/* This file is part of GNU Pies. -*- c -*-
   Copyright (C) 2008-2020 Sergey Poznyakoff

   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

#line 98 "piesctl-cl.opt"
#ifdef HAVE_CONFIG_H
#line 98
# include <config.h>
#line 98
#endif
#line 98
#ifdef HAVE_GETOPT_H
#line 98
# include <getopt.h>
#line 98
#endif
#line 98
#include <unistd.h>
#line 98
#include <stdlib.h>
#line 98
#include <grecs.h>
#line 98
#include <grecs/opt.h>
#line 98
#ifndef EX_USAGE
#line 98
# define EX_USAGE 64
#line 98
#endif
#line 98
/* Option codes */
#line 98
enum {
#line 98
	_OPTION_INIT=255,
#line 36 "piesctl-cl.opt"
	OPTION_CONFIG_HELP,
#line 98 "piesctl-cl.opt"
	OPTION_USAGE,
#line 98 "piesctl-cl.opt"
	MAX_OPTION
#line 98
};
#line 98
#ifdef HAVE_GETOPT_LONG
#line 98
static struct option long_options[] = {
#line 24 "piesctl-cl.opt"
	{ "instance", required_argument, 0, 'i' },
#line 30 "piesctl-cl.opt"
	{ "config-file", required_argument, 0, 'c' },
#line 36 "piesctl-cl.opt"
	{ "config-help", no_argument, 0, OPTION_CONFIG_HELP },
#line 49 "piesctl-cl.opt"
	{ "verbose", no_argument, 0, 'v' },
#line 55 "piesctl-cl.opt"
	{ "dump", no_argument, 0, 'd' },
#line 61 "piesctl-cl.opt"
	{ "url", required_argument, 0, 'u' },
#line 72 "piesctl-cl.opt"
	{ "no-netrc", no_argument, 0, 'N' },
#line 80 "piesctl-cl.opt"
	{ "include-directory", required_argument, 0, 'I' },
#line 86 "piesctl-cl.opt"
	{ "define", required_argument, 0, 'D' },
#line 92 "piesctl-cl.opt"
	{ "undefine", required_argument, 0, 'U' },
#line 98 "piesctl-cl.opt"
	{ "help", no_argument, 0, 'h' },
#line 98 "piesctl-cl.opt"
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 98 "piesctl-cl.opt"
	{ "version", no_argument, 0, 'V' },
#line 98 "piesctl-cl.opt"
	{0, 0, 0, 0}
#line 98
};
#line 98
#endif
#line 98

#line 98
static struct grecs_opthelp opthelp[] = {
#line 26 "piesctl-cl.opt"
	{
#line 26
#ifdef HAVE_GETOPT_LONG
#line 26
	  "-i, --instance",
#line 26
#else
#line 26
	  "-i",
#line 26
#endif
#line 26
				   N_("NAME"), 0, N_("connect to instance NAME") },
#line 32 "piesctl-cl.opt"
	{
#line 32
#ifdef HAVE_GETOPT_LONG
#line 32
	  "-c, --config-file",
#line 32
#else
#line 32
	  "-c",
#line 32
#endif
#line 32
				   N_("FILE"), 0, N_("use FILE instead of the default configuration") },
#line 38 "piesctl-cl.opt"
	{
#line 38
#ifdef HAVE_GETOPT_LONG
#line 38
	  "--config-help",
#line 38
#else
#line 38
	  "",
#line 38
#endif
#line 38
				   NULL, 0, N_("show configuration file summary") },
#line 45 "piesctl-cl.opt"
	{
#line 45
#ifdef HAVE_GETOPT_LONG
#line 45
	  "-E",
#line 45
#else
#line 45
	  "-E",
#line 45
#endif
#line 45
				   NULL, 0, N_("preprocess configuration files and exit") },
#line 51 "piesctl-cl.opt"
	{
#line 51
#ifdef HAVE_GETOPT_LONG
#line 51
	  "-v, --verbose",
#line 51
#else
#line 51
	  "-v",
#line 51
#endif
#line 51
				   NULL, 0, N_("verbose diagnostics") },
#line 57 "piesctl-cl.opt"
	{
#line 57
#ifdef HAVE_GETOPT_LONG
#line 57
	  "-d, --dump",
#line 57
#else
#line 57
	  "-d",
#line 57
#endif
#line 57
				   NULL, 0, N_("dump obtained responses verbatim") },
#line 63 "piesctl-cl.opt"
	{
#line 63
#ifdef HAVE_GETOPT_LONG
#line 63
	  "-u, --url",
#line 63
#else
#line 63
	  "-u",
#line 63
#endif
#line 63
				   N_("URL"), 0, N_("connect to this socket") },
#line 74 "piesctl-cl.opt"
	{
#line 74
#ifdef HAVE_GETOPT_LONG
#line 74
	  "-N, --no-netrc",
#line 74
#else
#line 74
	  "-N",
#line 74
#endif
#line 74
				   NULL, 0, N_("don't read ~/.netrc file") },
#line 78 "piesctl-cl.opt"
	{ NULL, NULL, 0, N_("Preprocessor") },
#line 82 "piesctl-cl.opt"
	{
#line 82
#ifdef HAVE_GETOPT_LONG
#line 82
	  "-I, --include-directory",
#line 82
#else
#line 82
	  "-I",
#line 82
#endif
#line 82
				   N_("DIR"), 0, N_("add include directory") },
#line 88 "piesctl-cl.opt"
	{
#line 88
#ifdef HAVE_GETOPT_LONG
#line 88
	  "-D, --define",
#line 88
#else
#line 88
	  "-D",
#line 88
#endif
#line 88
				   N_("NAME[=VALUE]"), 0, N_("define a preprocessor symbol NAME as having VALUE or empty") },
#line 94 "piesctl-cl.opt"
	{
#line 94
#ifdef HAVE_GETOPT_LONG
#line 94
	  "-U, --undefine",
#line 94
#else
#line 94
	  "-U",
#line 94
#endif
#line 94
				   N_("NAME"), 0, N_("undefine a preprocessor symbol NAME") },
#line 98 "piesctl-cl.opt"
	{ NULL, NULL, 0, N_("Other options") },
#line 98 "piesctl-cl.opt"
	{
#line 98
#ifdef HAVE_GETOPT_LONG
#line 98
	  "-h, --help",
#line 98
#else
#line 98
	  "-h",
#line 98
#endif
#line 98
				   NULL, 0, N_("Give this help list") },
#line 98 "piesctl-cl.opt"
	{
#line 98
#ifdef HAVE_GETOPT_LONG
#line 98
	  "--usage",
#line 98
#else
#line 98
	  "",
#line 98
#endif
#line 98
				   NULL, 0, N_("Give a short usage message") },
#line 98 "piesctl-cl.opt"
	{
#line 98
#ifdef HAVE_GETOPT_LONG
#line 98
	  "-V, --version",
#line 98
#else
#line 98
	  "-V",
#line 98
#endif
#line 98
				   NULL, 0, N_("Print program version") },
#line 98 "piesctl-cl.opt"
};
#line 17 "piesctl-cl.opt"

#line 17

#line 17
#ifndef PACKAGE_URL
#line 17
# define PACKAGE_URL NULL
#line 17
#endif
#line 17
static struct grecs_proginfo proginfo = {
#line 17
	"piesctl", /* progname */
#line 17
	NULL, /* subcommands */
#line 17
	N_("GNU pies control program"), /* docstring */
#line 17
	N_("COMMAND [ARG...]"), /* args_doc */
#line 17
	opthelp, /* opthelp */
#line 17
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 17
	NULL, /* print_help_hook */
#line 17
	NULL, /* print_version_hook */
#line 17
	PACKAGE_NAME,    /* package */
#line 17
	PACKAGE_VERSION, /* version */
#line 17
	NULL, /* license */
#line 17
	"2008-2020",/* copyright_year */
#line 17
	"Sergey Poznyakoff", /* copyright_holder */
#line 17
	NULL, /* *authors */
#line 17
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 17
	PACKAGE_URL, /* url */
#line 17
	NULL  /* epilogue */
#line 17
};
#line 17

#line 98 "piesctl-cl.opt"

#line 98


void
parse_options(int argc, char *argv[], int *index)
{
  
#line 103
 {
#line 103
  int c;
#line 103

#line 103
  optind = 0;
#line 103
#ifdef HAVE_GETOPT_LONG
#line 103
  while ((c = getopt_long(argc, argv, "i:c:Evdu:NI:D:U:hV",
#line 103
			  long_options, NULL)) != EOF)
#line 103
#else
#line 103
  while ((c = getopt(argc, argv, "i:c:Evdu:NI:D:U:hV")) != EOF)
#line 103
#endif
#line 103
    {
#line 103
      switch (c)
#line 103
	{
#line 103
	default:
#line 103
	   	   exit(EX_USAGE);
#line 103
	#line 26 "piesctl-cl.opt"
	 case 'i':
#line 26
	  {
#line 26

  instance = optarg;

#line 28
	     break;
#line 28
	  }
#line 32 "piesctl-cl.opt"
	 case 'c':
#line 32
	  {
#line 32

  config_file = optarg;

#line 34
	     break;
#line 34
	  }
#line 38 "piesctl-cl.opt"
	 case OPTION_CONFIG_HELP:
#line 38
	  {
#line 38

  config_help ();
  exit (0);

#line 41
	     break;
#line 41
	  }
#line 45 "piesctl-cl.opt"
	 case 'E':
#line 45
	  {
#line 45

  preprocess_only = 1;

#line 47
	     break;
#line 47
	  }
#line 51 "piesctl-cl.opt"
	 case 'v':
#line 51
	  {
#line 51

  ++verbose;

#line 53
	     break;
#line 53
	  }
#line 57 "piesctl-cl.opt"
	 case 'd':
#line 57
	  {
#line 57

  ++dump;

#line 59
	     break;
#line 59
	  }
#line 63 "piesctl-cl.opt"
	 case 'u':
#line 63
	  {
#line 63

  if (pies_url_create (&client.url, optarg))
    {
      grecs_error (NULL, 0, _("%s: cannot create URL: %s"),
		   optarg, strerror (errno));
      exit (EX_USAGE);
    }

#line 70
	     break;
#line 70
	  }
#line 74 "piesctl-cl.opt"
	 case 'N':
#line 74
	  {
#line 74

  no_netrc_option = 1;

#line 76
	     break;
#line 76
	  }
#line 82 "piesctl-cl.opt"
	 case 'I':
#line 82
	  {
#line 82

  grecs_preproc_add_include_dir (optarg);

#line 84
	     break;
#line 84
	  }
#line 88 "piesctl-cl.opt"
	 case 'D':
#line 88
	  {
#line 88

  pp_add_option ("-D", optarg);

#line 90
	     break;
#line 90
	  }
#line 94 "piesctl-cl.opt"
	 case 'U':
#line 94
	  {
#line 94

  pp_add_option ("-U", optarg);

#line 96
	     break;
#line 96
	  }
#line 98 "piesctl-cl.opt"
	 case 'h':
#line 98
	  {
#line 98

#line 98
		grecs_print_help(&proginfo);
#line 98
		exit(0);
#line 98
	 
#line 98
	     break;
#line 98
	  }
#line 98 "piesctl-cl.opt"
	 case OPTION_USAGE:
#line 98
	  {
#line 98

#line 98
		grecs_print_usage(&proginfo);
#line 98
		exit(0);
#line 98
	 
#line 98
	     break;
#line 98
	  }
#line 98 "piesctl-cl.opt"
	 case 'V':
#line 98
	  {
#line 98

#line 98
	        /* Give version */
#line 98
		grecs_print_version(&proginfo, stdout);
#line 98
		exit(0);
#line 98
	 
#line 98
	     break;
#line 98
	  }

#line 103 "piesctl-cl.opt"
	}
#line 103
    }
#line 103
  *index = optind;
#line 103
 }
#line 103

  setenv ("PIES_INSTANCE", instance, 1);
}


	      
