# Facebook FBG-1701

This page describes how to run coreboot on the Facebook FBG1701.

FBG1701 are assembled with different onboard memory modules:
	Rev 1.0	Onboard Samsung K4B8G1646D-MYKO memory
	Rev 1.1 and 1.2	Onboard Micron MT41K512M16HA-125A memory
	Rev 1.3	Onboard Kingston B5116ECMDXGGB memory

Use make menuconfig to configure `onboard memory manufacturer Samsung` in
Mainboard menu.

## Required blobs

This board currently requires:
fsp blob	3rdparty/fsp/BraswellFspBinPkg/FspBin/BSWFSP.fd
Microcode	3rdparty/intel-microcode/intel-ucode/06-4c-04

## Flashing coreboot

### Internal programming

The main SPI flash can be accessed using [flashrom].

### External programming

The system has an internal flash chip which is a 8 MiB soldered SOIC-8 chip.
This chip is located on the top middle side of the board. It's located
between SoC and Q7 connector. Use clip (or solder wires) to program
the chip.
Specifically, it's a Winbond W25Q64FW (1.8V), whose datasheet can be found
[here][W25Q64FW].

The system has an external flash chip which is a 8 MiB soldered SOIC-8 chip.
This chip is located in the middle of carrier board close to the flex cable
connection.
Specifically, it's a Winbond W25Q64FV (3.3V), whose datasheet can be found
[here][W25Q64FV].

## Known issues

- None

## Untested

- hardware monitor
- SDIO
- Full Embedded Controller support

## Working

- USB
- Gigabit Ethernet
- integrated graphics
- flashrom
- external graphics
- PCIe
- eMMC
- SATA
- serial port
- SMBus
- HDA
- initialization with FSP MR2
- SeaBIOS payload
- Embedded Linux (Ubuntu 4.15+)

## Technology

```eval_rst
+------------------+--------------------------------------------------+
| SoC              | Intel Atom Processor N3710                       |
+------------------+--------------------------------------------------+
| CPU              | Intel Braswell (N3710)                           |
+------------------+--------------------------------------------------+
| Super I/O, EC    | ITE8256                                          |
+------------------+--------------------------------------------------+
| Coprocessor      | Intel Management Engine                          |
+------------------+--------------------------------------------------+
```

[W25Q64FW]: https://www.winbond.com/resource-files/w25q64fw%20revn%2005182017%20sfdp.pdf
[W25Q64FV]: https://www.winbond.com/resource-files/w25q64fv%20revs%2007182017.pdf
[flashrom]: https://flashrom.org/Flashrom
