/**
 * Various things to compute during the game

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2003, 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/processes.c,v 1.5 2004/01/16 19:55:45 Beuc Exp $
 */

#include <time.h>
#include "dink.h"

void
process_bow (int h)
{
  int timetowait = 100;


  if (bow.wait < thisTickCount)
    {
      if (sjoy.right)
	spr[h].dir = 6;
      if (sjoy.left)
	spr[h].dir = 4;
      if (sjoy.up)
	spr[h].dir = 8;
      if (sjoy.down)
	spr[h].dir = 2;
    }



  if (sjoy.right)
    if (sjoy.up)
      {
	spr[h].dir = 9;
	bow.wait = thisTickCount + timetowait;
      }
  if (sjoy.left)
    if (sjoy.up)
      {
	spr[h].dir = 7;
	bow.wait = thisTickCount + timetowait;
      }
  if (sjoy.right)
    if (sjoy.down)
      {
	spr[h].dir = 3;
	bow.wait = thisTickCount + timetowait;

      }
  if (sjoy.left)
    if (sjoy.down)
      {
	spr[h].dir = 1;
	bow.wait = thisTickCount + timetowait;

      }
  spr[h].pseq = 100 + spr[h].dir;


  if (bow.pull_wait < thisTickCount)
    {
      bow.pull_wait = thisTickCount + 10;
      if (bow.hitme)
	bow.time += 7;


      /* bowsound->SetFrequency(22050+(bow.time*10)); */

      if (bow.time > 500)
	bow.time = 500;
      spr[h].pframe = (bow.time / 100) + 1;
    }


  if (sjoy.letgo[1])
    {
      bow.active = 0;
      bow.last_power = bow.time;
      run_script (bow.script);
      /* bowsound->Stop(); */
      return;
    }

}


void
run_through_tag_list (int h, int strength)
{
  struct rect box;
  int amount, amounty;
  int i;

  for (i = 1; i <= last_sprite_created; i++)
    {
      if (spr[i].active)
	if (i != h)
	  if (!((spr[i].nohit == 1) && (spr[i].script == 0)))
	    {
	      int range_amount;
	      CopyRect (&box, &k[getpic (i)].hardbox);
	      OffsetRect (&box, spr[i].x, spr[i].y);

	      /* InflateRect(&box, 10,10); */

	      box.right += 5;
	      box.left -= 5;
	      box.top -= 5;
	      box.bottom += 10;
	      if (spr[h].range == 0)
		amount = 28;
	      else
		amount = spr[h].range;

	      if (spr[h].range == 0)

		amounty = 36;
	      else
		amounty = (spr[h].range + (spr[h].range / 6));

	      range_amount = spr[h].range / 8;

	      if (spr[h].dir == 6)
		{
		  box.top -= 10;
		  box.bottom += 10;
		  if (spr[h].range != 0)
		    box.top -= range_amount;
		  if (spr[h].range != 0)
		    box.bottom += range_amount;


		  box.left -= amount;
		}

	      if (spr[h].dir == 4)
		{
		  box.right += amount;

		  box.top -= 10;
		  box.bottom += 10;
		  if (spr[h].range != 0)
		    box.top -= range_amount;
		  if (spr[h].range != 0)
		    box.bottom += range_amount;

		}


	      if (spr[h].dir == 2)
		{
		  box.right += 10;
		  box.left -= 10;
		  box.top -= amounty;

		  if (spr[h].range != 0)
		    box.right += range_amount;
		  if (spr[h].range != 0)
		    box.left -= range_amount;

		}

	      if (spr[h].dir == 8)
		{
		  box.right += 10;
		  box.left -= 10;
		  box.bottom += amounty;

		  if (spr[h].range != 0)
		    box.right += range_amount;
		  if (spr[h].range != 0)
		    box.right -= range_amount;

		}

	      if (debug_mode)
		draw_box (box, 33);

	      if (inside_box (spr[h].x, spr[h].y, box))
		{

		  if (spr[i].nohit == 1)
		    {
		      if (spr[i].script > 0)
			{
			  /* if (  (spr[i].brain == 0) | (spr[i].brain == 5) | (spr[i].brain == 6) | (spr[i].brain == 7)) */
			  *penemy_sprite = h;

			  if ((spr[i].base_attack != -1)
			      || (spr[i].touch_damage > 0))
			    spr[i].target = h;

			  if (locate (spr[i].script, "HIT"))
			    {
			      kill_returning_stuff (spr[i].script);
			      run_script (spr[i].script);
			    }


			}


		    }
		  else
		    {
		      /* hit this personb/thing */
		      if (spr[h].attack_hit_sound == 0)
			{
			  SoundPlayEffect (9, 22050, 0, 0, 0);
			}
		      else
			{
			  SoundPlayEffect (spr[h].attack_hit_sound,
					   spr[h].attack_hit_sound_speed, 0,
					   0, 0);
			}
		      if ((spr[i].base_attack != -1)
			  || (spr[i].touch_damage > 0))
			spr[i].target = h;
		      if (spr[h].strength == 0)
			{

			}
		      else
			{
			  if ((spr[i].hitpoints > 0) || (i == 1))
			    {

			      spr[i].last_hit = h;
			      if (hurt_thing
				  (i,
				   (spr[h].strength / 2) +
				   ((rand () % ((spr[h].strength + 1) / 2)) +
				    1), 0) > 0)
				random_blood (spr[i].x, spr[i].y - 40, h);
			    }

			}
		      if (spr[i].script > 0)
			{
			  /* if (  (spr[i].brain == 0) | (spr[i].brain == 5) | (spr[i].brain == 6) | (spr[i].brain == 7)) */
			  spr[i].last_hit = h;
			  *penemy_sprite = h;
			  if ((spr[i].base_attack != -1)
			      || (spr[i].touch_damage > 0))
			    spr[i].target = h;

			  if (locate (spr[i].script, "HIT"))
			    {
			      kill_returning_stuff (spr[i].script);
			      run_script (spr[i].script);
			    }

			}

		    }

		}

	    }

    }

}



void
run_through_tag_list_push (int h)
{
  struct rect box;
  int i;

  for (i = 1; i <= last_sprite_created; i++)

    {

      if (spr[i].active)
	if (i != h)
	  if ((spr[i].script != 0))

	    {



	      CopyRect (&box, &k[getpic (i)].hardbox);

	      OffsetRect (&box, spr[i].x, spr[i].y);



	      /* InflateRect(&box, 10,10); */



	      box.right += 2;

	      box.left -= 2;

	      box.top -= 2;

	      box.bottom += 2;

	      /* draw_box(box, 33); */



	      if (inside_box (spr[h].x, spr[h].y, box))

		{

		  if (locate (spr[i].script, "PUSH"))
		    run_script (spr[i].script);

		}



	    }



    }



}

void
run_through_touch_damage_list (int h)
{

  struct rect box;
  int i;
  /* UNREFERENCED  int amount, amounty; */

  for (i = 1; i <= last_sprite_created; i++)

    {

      if (spr[i].active)
	if (i != h)
	  if ((spr[i].touch_damage != 0))

	    {



	      if (spr[i].touch_damage != -1)
		if (spr[h].notouch)
		  return;

	      CopyRect (&box, &k[getpic (i)].hardbox);

	      OffsetRect (&box, spr[i].x, spr[i].y);



	      /* InflateRect(&box, 10,10); */



	      box.right += 2;

	      box.left -= 2;

	      box.top -= 2;

	      box.bottom += 2;

	      if (debug_mode)

		draw_box (box, 33);





	      if (inside_box (spr[h].x, spr[h].y, box))

		{



		  if ((spr[i].touch_damage == -1) && (spr[i].script != 0))

		    {

		      if (locate (spr[i].script, "TOUCH"))
			run_script (spr[i].script);

		    }
		  else

		    {

		      if (spr[i].touch_damage == -1)

			{

			  Msg (("Sprites touch damage is set to -1 but there is no script set!"));

			}
		      else

			{

			  /* lets hurt the guy */



			  spr[h].notouch = 1;

			  spr[h].notouch_timer = thisTickCount + 400;

			  spr[h].last_hit = i;

			  if (spr[i].script != 0)

			    if (locate (spr[i].script, "TOUCH"))
			      run_script (spr[i].script);

			  if (hurt_thing (h, spr[i].touch_damage, 0) > 0)

			    random_blood (spr[h].x, spr[h].y - 40, h);
			}



		    }

		}

	    }

    }

}


void
process_warp_man (void)
{
  struct rect box_crap;

/* DDBLTFX     ddbltfx; */

  int sprite = find_sprite (process_warp);


  if (spr[sprite].seq == 0)
    {

      process_count++;
      CyclePalette ();
      if (process_count > 5)
	{
	  int block;

	  /* ddbltfx.dwSize = sizeof(ddbltfx); */
	  /* ddbltfx.dwFillColor = 0; */
	  SetRect (&box_crap, 0, 0, 640, 480);

	  /* ddrval = lpDDSBack->Blt(&box_crap ,NULL, NULL, DDBLT_COLORFILL| DDBLT_WAIT, &ddbltfx); */
	  fill_rect (lpDDSBack, &box_crap, 0);

	  flip_it ();

	  process_count = 0;
	  block = process_warp;

	  update_screen_time ();
	  spr[1].x = pam.sprite[block].warp_x;
	  spr[1].y = pam.sprite[block].warp_y;
	  *pmap = pam.sprite[block].warp_map;

	  load_map (map.loc[pam.sprite[block].warp_map]);
	  draw_map_game ();

	  process_upcycle = 1;
	  process_warp = 0;
	}

    }
  else
    {
      process_count = 0;

    }

}



void
run_through_mouse_list (int h, /*bool*/int special)
{

  struct rect box;
  int i;
  /* UNREFERENCED   int amount, amounty; */

  for (i = 1; i <= last_sprite_created; i++)
    {
      if (spr[i].active)
	if (i != h)
	  if ((spr[i].touch_damage != 0))
	    {
	      if (spr[i].touch_damage != -1)
		if (spr[h].notouch)
		  return;

	      CopyRect (&box, &k[getpic (i)].hardbox);
	      OffsetRect (&box, spr[i].x, spr[i].y);

	      if (inside_box (spr[h].x, spr[h].y, box))
		{
		  if ((spr[i].touch_damage == -1) && (spr[i].script != 0))
		    {
		      Msg (("running %d's script..", spr[i].script));
		      if (locate (spr[i].script, "CLICK"))
			run_script (spr[i].script);
		    }
		  else
		    {
		      if (spr[i].touch_damage == -1)
			{
			  Msg (("Sprites touch damage is set to -1 but there is no script set!"));
			}
		      else
			{
			  /* lets hurt the guy */
			}
		    }

		  if (special)
		    return;
		}
	    }
    }

  if (special)
    SoundPlayEffect (19, 22050, 0, 0, 0);
}


void
process_item (void)
{
  struct rect rcRect;
  int hor, virt;
  int i;
  rcRect.left = 0;
  rcRect.top = 0;
  rcRect.right = x;
  rcRect.bottom = y;

  BltFast (lpDDSBack, 0, 0, lpDDSTwo, &rcRect);
  check_seq_status (423);

  /* lets blit the main screen over it */
  /* UNREFERENCED again: */

  BltFast (lpDDSBack, 20, 0, k[seq[423].frame[1]].k,
	   &k[seq[423].frame[1]].box);

  /* draw all currently owned items; magic */
  for (i = 1; i < 9; i++)
    {
      if (play.mitem[i].active)
	draw_item (i, 1, play.mitem[i].seq, play.mitem[i].frame);
    }

  /* draw all currently owned items; normal */
  for (i = 1; i < 17; i++)
    {
      if (play.item[i].active)
	draw_item (i, 0, play.item[i].seq, play.item[i].frame);
    }

  /* draw selection box around armed weapon */
  if (*pcur_weapon != 0)
    if (play.item[*pcur_weapon].active)
      draw_item (*pcur_weapon, 0, 423, 4);

  /* draw selection box around armed magic */
  if (*pcur_magic != 0)
    if (play.item[*pcur_magic].active)
      draw_item (*pcur_magic, 1, 423, 5);

  /* draw the selector around it, alternating from 2 to 3 */
  if (play.curitem < 1)
    play.curitem = 1;

  if (thisTickCount > item_timer)
    {
      if (item_pic == 2)
	item_pic = 3;
      else
	item_pic = 2;
      item_timer = thisTickCount + 400;
    }

  draw_item (play.curitem, play.item_magic, 423, item_pic);

  if (!play.item_magic)
    {
      hor = (play.curitem - (((play.curitem - 1) / 4) * 4));
      virt = ((play.curitem - 1) / 4);

      /* choosing weapon/item */
      if (sjoy.button[1])
	{
	  if (play.item[play.curitem].active)
	    {
	      /* arm weapon */
	      SoundPlayEffect (18, 42050, 0, 0, 0);
	      if (*pcur_weapon != 0)
		{
		  /* disarm old weapon */
		  if (locate (weapon_script, "DISARM"))
		    run_script (weapon_script);
		}
	      /* load weapons script */
	      *pcur_weapon = play.curitem;
	      weapon_script =
		load_script (play.item[*pcur_weapon].name, 1000, 0);
	      if (locate (weapon_script, "ARM"))
		run_script (weapon_script);
	      if (locate (weapon_script, "ARMMOVIE"))
		run_script (weapon_script);
	      draw_status_all ();
	    }
	  else
	    {
	      /* can't arm nothing, play sound */
	    }
	}
      else
       if (sjoy.rightd)
	{
	  if (hor < 4)
	    play.curitem++;
	  SoundPlayEffect (11, 22050, 0, 0, 0);
	}
      else
       if (sjoy.leftd)
	{
	  if (hor > 1)
	    {
	      play.curitem--;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	  else
	    {
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	      play.item_magic = 1;
	      play.curitem = (virt * 2) + 2;
	      /* switch to magic mode */
	    }
	}
      else
       if (sjoy.downd)
	{
	  if (virt < 3)
	    {
	      play.curitem += 4;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	}
      else
       if (sjoy.upd)
	{
	  if (virt > 0)
	    {
	      play.curitem -= 4;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	}
    }
  else
    {
      hor = (play.curitem - (((play.curitem - 1) / 2) * 2));
      virt = ((play.curitem - 1) / 2);

      if (sjoy.button[1])
	{
	  if (play.mitem[play.curitem].active)
	    {
	      /* arm magic */
	      SoundPlayEffect (18, 42050, 0, 0, 0);
	      if (*pcur_magic != 0)
		{
		  /* disarm old weapon */
		  if (locate (magic_script, "DISARM"))
		    run_script (magic_script);
		}
	      /* load magics script */
	      *pcur_magic = play.curitem;
	      magic_script =
		load_script (play.mitem[*pcur_magic].name, 1000, 0);
	      if (locate (magic_script, "ARM"))
		run_script (magic_script);
	      if (locate (magic_script, "ARMMOVIE"))
		run_script (magic_script);
	      draw_status_all ();
	    }
	  else
	    {
	      /* can't arm nothing, play sound */
	    }
	}

      if (sjoy.rightd)
	{
	  if (hor < 2)
	    {
	      play.curitem++;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	  else
	    {
	      play.item_magic = 0;
	      play.curitem = (virt * 4) + 1;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	}
      else
       if (sjoy.leftd)
	{
	  if (hor > 1)
	    {
	      play.curitem--;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	}
      else
       if (sjoy.downd)
	{
	  if (virt < 3)
	    {
	      play.curitem += 2;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	}
      else
       if (sjoy.upd)
	{
	  if (virt > 0)
	    {
	      play.curitem -= 2;
	      SoundPlayEffect (11, 22050, 0, 0, 0);
	    }
	}
    }

  if (talk.active)
    process_talk ();

  /* a special process callbacks for just stuff that was created in this mode? */
  /* process_callbacks_special(); */
  flip_it ();

  if (sjoy.button[4])
    {
      SoundPlayEffect (17, 22050, 0, 0, 0);
      item_screen = 0;
    }
}


void
process_animated_tiles (void)
{
  struct rect rcRect;
  int cool;
  int flip;
  int pa;

  /* process water tiles */
  if (water_timer < thisTickCount)
    {
      int x;
      water_timer = thisTickCount + ((rand () % 2000));
      flip = ((rand () % 2) + 1);
      for (x = 0; x < 96; x++)
	{
	  if (pam.t[x].num > 896)
	    if (pam.t[x].num < (896 + 128))
	      {
		cool = pam.t[x].num / 128;
		pa = pam.t[x].num - (cool * 128);
		rcRect.left = (pa * 50 - (pa / 12) * 600);
		rcRect.top = (pa / 12) * 50;
		rcRect.right = rcRect.left + 50;
		rcRect.bottom = rcRect.top + 50;

		BltFast (lpDDSTwo, (x * 50 - ((x / 12) * 600)) + playl,
			 (x / 12) * 50, tiles[cool + flip], &rcRect);

	      }
	}
    }
  /* end of water processing */
  {
    int x;
    if (fire_forward)
      fire_flip++;

    if (!fire_forward)
      fire_flip--;

    if (fire_flip < 1)
      {
	fire_flip = 5;
	fire_forward = 0;
      }

    for (x = 0; x < 96; x++)
      {
	if (pam.t[x].num > 2304)
	  if (pam.t[x].num < (2304 + 128))
	    {
	      cool = pam.t[x].num / 128;
	      pa = pam.t[x].num - (cool * 128);
	      rcRect.left = (pa * 50 - (pa / 12) * 600);
	      rcRect.top = (pa / 12) * 50;
	      rcRect.right = rcRect.left + 50;
	      rcRect.bottom = rcRect.top + 50;
	      BltFast (lpDDSTwo, (x * 50 - ((x / 12) * 600)) + playl,
		       (x / 12) * 50, tiles[cool + fire_flip], &rcRect);
	    }
      }
  }
  /* end of water processing */
}


int
special_block (int block, int h)
{
  if (pam.sprite[block].prop == 1)
    {
      /* they touched a warp */
      if (pam.sprite[block].sound == 0)
	SoundPlayEffect (7, 12000, 0, 0, 0);
      else
	SoundPlayEffect (pam.sprite[block].sound, 22050, 0, 0, 0);

      if (pam.sprite[block].parm_seq != 0)
	{
	  /* we'll also play an animation here */
	  int sprite = find_sprite (block);
	  if (sprite > 0)
	    {
	      spr[sprite].seq = pam.sprite[block].parm_seq;
	      process_warp = block;
	    }

	  return (1);
	}

      process_warp = block;
      /*spr[1].x = pam.sprite[block].warp_x;
         spr[1].y = pam.sprite[block].warp_y;
         *pmap = pam.sprite[block].warp_map;  

         load_map(map.loc[pam.sprite[block].warp_map]);
         draw_map();
       */
      return (1);		/* redraw screen with fade */
    }
  return (0);
}

/**
 * This is where all the DinkC magic takes place. Read it if you can.
 */
int process_line (int script, char *s, /*bool*/int doelse)
{
  char *h, *p;
  int i;
  char line[200];
  char ev[15][100];
  char temp[100];
  char first[2];
/* UNREFERENCED   char rstring[200]; */
/* UNREFERENCED   int rint; */
  int sprite = 0;
  int kk;

  if (rinfo[script]->level < 1)
    rinfo[script]->level = 1;


  for (kk = 1; kk < 15; kk++)
    ev[kk][0] = 0;
/* UNREFERENCED   refinfo save_rinfo; */

  h = s;
  if (h[0] == 0)
    return (0);
  if ((h[0] == '/') && (h[1] == '/'))
    {
      /* Msg(("It was a comment!")); */
      goto bad;
    }

  for (i = 1; i <= 14; i++)
    {
      if (seperate_string (h, i, ' ', ev[i]) == 0)
	goto pass;
    }

pass:
  /* Msg(("first line is %s (second is %s)", ev[1], ev[2])); */
  if (compare (ev[1], "VOID"))
    {

      if (rinfo[script]->proc_return != 0)
	{
	  run_script (rinfo[script]->proc_return);
	  kill_script (script);
	}
      /* Msg(("returning..")); */
      return (2);
    }
  /* replace("\n","",ev[1]); */
  if (ev[1][strlen (ev[1]) - 1] == ':')
    if (strlen (ev[2]) < 2)
      {
	/* Msg(("Found label %s..",ev[1])); */
	return (0);		/* its a label */
      }
  if (ev[1][0] == '(')
    {
      /* this procedure has been passed a conditional statement finder */
      /* what kind of conditional statement is it? */
      p = h;
      seperate_string (h, 2, ')', temp);
      /* Msg(("We found %s, woah!", temp)); */
      seperate_string (h, 1, ')', ev[1]);

      /* Msg(("Ok, turned h %s to  ev1 %s.",h,ev[1])); */
      p = &p[strlen (ev[1]) + 1];

      strip_beginning_spaces (p);
      /* Msg(("does %s have a ( in front?", p)); */
      /* Msg(("We found %s, woah!", temp)); */

      if (strchr (temp, '=') != NULL)
	{
	  h = &h[1];
	  strip_beginning_spaces (h);
	  process_line (script, h, 0);
	  replace ("==", "", temp);
	  sprintf (line, "%d == %s", returnint, temp);
	  returnint = var_figure (line, script);
	  strcpy (h, "\n");
	  return (0);
	}

      if (strchr (temp, '>') != NULL)
	{
	  h = &h[1];
	  strip_beginning_spaces (h);
	  process_line (script, h, 0);
	  replace ("==", "", temp);
	  sprintf (line, "%d > %s", returnint, temp);
	  returnint = var_figure (line, script);
	  strcpy (h, "\n");
	  return (0);
	}

      if (strchr (temp, '<') != NULL)
	{
	  h = &h[1];
	  strip_beginning_spaces (h);
	  process_line (script, h, 0);
	  replace ("==", "", temp);
	  sprintf (line, "%d < %s", returnint, temp);
	  returnint = var_figure (line, script);
	  strcpy (h, "\n");
	  return (0);
	}

      /* Beuc: This should be converted to a set of "if ... else
       * if... else if ..." and multi-character cosntants should be
       * removed. However, this may cause the interpreter to behave
       * differently, so be careful. */
       /* Still, I'll rewrite the code in an equivalent warning-free
        * inelegant way: strchr(str, 'ab') <=> strchr(str, 'b') */
       /* if (strchr (temp, '<=') != NULL) */
      if (strchr (temp, '=') != NULL)
	{
	  h = &h[1];
	  strip_beginning_spaces (h);
	  process_line (script, h, 0);
	  replace ("==", "", temp);
	  sprintf (line, "%d <= %s", returnint, temp);
	  returnint = var_figure (line, script);
	  strcpy (h, "\n");
	  return (0);
	}
      /* if (strchr (temp, '>=') != NULL) */
      if (strchr (temp, '=') != NULL)
	{
	  h = &h[1];
	  strip_beginning_spaces (h);
	  process_line (script, h, 0);
	  replace ("==", "", temp);
	  sprintf (line, "%d >= %s", returnint, temp);
	  returnint = var_figure (line, script);
	  strcpy (h, "\n");
	  return (0);
	}
      /* if (strchr (temp, '!=') != NULL) */
      if (strchr (temp, '=') != NULL)
	{
	  h = &h[1];
	  strip_beginning_spaces (h);
	  process_line (script, h, 0);
	  replace ("==", "", temp);
	  sprintf (line, "%d != %s", returnint, temp);
	  returnint = var_figure (line, script);
	  strcpy (h, "\n");
	  return (0);
	}


      if (p[0] == ')')
	{
	  /* its a procedure in the if statement!!! */
	  h = &h[1];
	  p = &p[1];
	  strcpy (line, p);
	  process_line (script, h, 0);

	  /* 8 */
	  Msg (("Returned %d for the returnint", returnint));
	  h = s;
	  strcpy (s, line);

	  /* Msg(("Returing %s..", s)); */
	  return (0);
	}
      else
	{
	  h = &h[1];

	  seperate_string (h, 1, ')', line);
	  h = &h[strlen (line) + 1];
	  returnint = var_figure (line, script);

	  strcpy (s, h);

	  return (0);
	}

      strip_beginning_spaces (h);
      strip_beginning_spaces (ev[1]);

      s = h;


    }
  else
    {



    }


  if (strchr (ev[1], '(') != NULL)
    {
      /* Msg(("Has a (, lets change it")); */
      seperate_string (h, 1, '(', ev[1]);
      /* Msg(("Ok, first is now %s",ev[1])); */


    }

  sprintf (first, "%c", ev[1][0]);



  if (compare (first, "{"))
    {


      rinfo[script]->level++;
      /* Msg(("Went up level, now at %d.", rinfo[script]->level)); */
      h = &h[1];
      if (rinfo[script]->skipnext)
	{
	  rinfo[script]->skipnext = 0;
	  rinfo[script]->onlevel = (rinfo[script]->level - 1);
	  /* Msg(("Skipping until level %d is met..", rinfo[script]->onlevel)); */

	}
      goto good;
    }

  if (compare (first, "}"))
    {
      rinfo[script]->level--;
      /* Msg(("Went down a level, now at %d.", rinfo[script]->level)); */
      h = &h[1];

      if (rinfo[script]->onlevel > 0)
	if (rinfo[script]->level == rinfo[script]->onlevel)
	  {
	    strip_beginning_spaces (h);

	    strcpy (s, h);
	    return (4);
	  }
      goto good;
    }




  if (rinfo[script]->level < 0)
    {
      rinfo[script]->level = 0;
    }

  if (compare (ev[1], "void"))
    {
      /* Msg(("Next procedure starting, lets quit")); */
      strcpy (s, h);
      if (rinfo[script]->proc_return != 0)
	{
	  run_script (rinfo[script]->proc_return);
	  kill_script (script);
	}

      return (2);
    }


  {				/* used to be an if.. */


    if (rinfo[script]->onlevel > 0)
      {
	if (rinfo[script]->level > rinfo[script]->onlevel)
	  return (0);

      }
    rinfo[script]->onlevel = 0;

    if (rinfo[script]->skipnext)
      {
	/* sorry, can't do it, you were told to skip the next thing */
	rinfo[script]->skipnext = 0;
	strcpy (s, h);
	return (3);
      }
    /* if (debug_mode) Msg(("%s",s)); */


    if (compare (ev[1], "void"))
      {
	Msg (("ERROR: Missing } in %s, offset %ld.", rinfo[script]->name,
	      rinfo[script]->current));
	strcpy (s, h);
	return (2);
      }

    if (compare (ev[1], "else"))
      {
	/* Msg(("Found else!")); */
	h = &h[strlen (ev[1])];


	if (doelse)
	  {
	    /* Msg(("Yes to else...")); */



	  }
	else
	  {
	    /* they shouldn't run the next thing */
	    rinfo[script]->skipnext = 1;
	    /* Msg(("No to else...")); */

	  }
	strcpy (s, h);
	return (1);

      }

    if (compare (ev[1], "unfreeze"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("unfreeze"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* Msg(("UnFreeze called for %d.", nlist[0])); */
	    if (spr[nlist[0]].active)
	      spr[nlist[0]].freeze = 0;
	    else
	      Msg (("Couldn't unfreeze sprite %ld in script %d, it doesn't exist.", nlist[0], script));
	  }
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "freeze"))
      {
	/* Msg(("Freeze called (%s)", h)); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (spr[nlist[0]].active)
	      spr[nlist[0]].freeze = script;
	    else
	      Msg (("Couldn't freeze sprite %ld in script %d, it doesn't exist.", nlist[0], script));

	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "set_callback_random"))
      {
	int p[20] = { 2, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("setting callback random"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* int cb =  */
	    add_callback (slist[0], nlist[1], nlist[2], script);
	    /* got all parms, let do it */
	  }
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "set_dink_speed"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("setting callback random"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    dinkspeed = nlist[0];
	  }
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "reset_timer"))
      {
	h = &h[strlen (ev[1])];
	time (&time_start);
	play.minutes = 0;
	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "set_keep_mouse"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("setting callback random"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    keep_mouse = nlist[0];

	  }

	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "add_item"))
      {
	int p[20] = { 2, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    add_item (slist[0], nlist[1], nlist[2], 0);
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "add_exp"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    add_exp (nlist[0], nlist[1]);
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "add_magic"))
      {
	int p[20] = { 2, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    add_item (slist[0], nlist[1], nlist[2], 1);
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "kill_this_item"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    kill_cur_item_script (slist[0]);
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "kill_this_magic"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    kill_cur_magic_script (slist[0]);
	  }

	strcpy (s, h);
	return (0);
      }



    if (compare (ev[1], "show_bmp"))
      {
	int p[20] = { 2, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("showing BMP"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    wait.active = 0;
	    show_bmp (slist[0], nlist[1], nlist[2], script);
	  }

	strcpy (s, h);
	return (2);
      }


    if (compare (ev[1], "wait_for_button"))
      {
	Msg (("waiting for button with script %d", script));
	h = &h[strlen (ev[1])];
	strcpy (s, h);
	wait.script = script;
	wait.active = 1;
	wait.button = 0;
	return (2);
      }

    if (compare (ev[1], "stop_wait_for_button"))
      {
	wait.active = 0;

	return (0);
      }


    if (compare (ev[1], "copy_bmp_to_screen"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("copying BMP"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    copy_bmp (slist[0]);

	  }

	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "say"))
      {
	int p[20] = { 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    if (nlist[1] == 0)
	      {
		Msg (("Say_stop error:  Sprite 0 can talk? Yeah, didn't think so."));
		return (0);
	      }

	    if (nlist[1] != 1000)
	      kill_text_owned_by (nlist[1]);
	    decipher_string (slist[0], script);
	    returnint = say_text (slist[0], nlist[1], script);
	    /* Msg(("Just said %s.", slist[0])); */
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "draw_screen"))
      {

	if (rinfo[script]->sprite == 1000)
	  {
	    draw_map_game ();
	    return (0);
	  }
	draw_map_game ();
	return (2);
      }


    if (compare (ev[1], "free_items"))
      {
	int i;
	returnint = 0;
	for (i = 1; i < 17; i++)
	  {
	    if (play.item[i].active == 0)
	      {
		returnint += 1;
	      }
	  }
	return (0);
      }


    if (compare (ev[1], "kill_cur_item"))
      {
	returnint = 0;
	kill_cur_item ();
	return (2);
      }



    if (compare (ev[1], "kill_cur_magic"))
      {
	returnint = 0;
	kill_cur_magic ();
	return (2);
      }



    if (compare (ev[1], "free_magic"))
      {
	int i;
	returnint = 0;
	for (i = 1; i < 9; i++)
	  {
	    if (play.mitem[i].active == 0)
	      {
		returnint += 1;
	      }
	  }
	return (0);
      }




    if (compare (ev[1], "draw_status"))
      {
	draw_status_all ();
	return (0);
      }


    if (compare (ev[1], "arm_weapon"))
      {

	if (weapon_script != 0)
	  if (locate (weapon_script, "DISARM"))
	    run_script (weapon_script);
	weapon_script =
	  load_script (play.item[*pcur_weapon].name, 1000, 0);
	if (locate (weapon_script, "ARM"))
	  run_script (weapon_script);


	return (0);
      }

    if (compare (ev[1], "arm_magic"))
      {


	if (magic_script != 0)
	  if (locate (magic_script, "DISARM"))
	    run_script (magic_script);
	magic_script =
	  load_script (play.mitem[*pcur_magic].name, 1000, 0);
	if (locate (magic_script, "ARM"))
	  run_script (magic_script);

	return (0);
      }


    if (compare (ev[1], "load_screen"))
      {
	/* Msg(("Loading map %d..",*pmap)); */
	update_screen_time ();
	load_map (map.loc[*pmap]);
	return (0);
      }


    if (compare (ev[1], "choice_start"))
      {

	kill_text_owned_by (1);
	if (talk_get (script))
	  {

	    /* Msg(("Question gathered successfully.")); */
	    return (2);
	  }

	return (0);
      }


    if (compare (ev[1], "say_stop"))
      {
	int p[20] = { 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (nlist[1] == 0)
	      {
		Msg (("Say_stop error:  Sprite 0 can talk? Yeah, didn't think so."));
		return (0);
	      }

	    kill_text_owned_by (nlist[1]);
	    kill_text_owned_by (1);
	    kill_returning_stuff (script);

	    decipher_string (slist[0], script);
	    sprite = say_text (slist[0], nlist[1], script);
	    returnint = sprite;
	    spr[sprite].callback = script;
	    play.last_talk = script;
	    /* Msg(("Sprite %d marked callback true.", sprite)); */

	    strcpy (s, h);

	    return (2);

	  }

	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "say_stop_npc"))
      {
	int p[20] = { 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    if (text_owned_by (nlist[1]))
	      {
		returnint = 0;
		return (0);
	      }

	    kill_returning_stuff (script);
	    decipher_string (slist[0], script);
	    sprite = say_text (slist[0], nlist[1], script);
	    returnint = sprite;
	    spr[sprite].callback = script;
	    strcpy (s, h);

	    return (2);

	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "say_stop_xy"))
      {
	int p[20] = { 2, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    Msg (("Say_stop_xy: Adding %s", slist[0]));
	    kill_returning_stuff (script);
	    decipher_string (slist[0], script);
	    sprite = say_text_xy (slist[0], nlist[1], nlist[2], script);
	    spr[sprite].callback = script;
	    spr[sprite].live = 1;
	    play.last_talk = script;
	    strcpy (s, h);

	    return (2);

	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "say_xy"))
      {
	int p[20] = { 2, 1, 1, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    kill_returning_stuff (script);
	    decipher_string (slist[0], script);
	    sprite = say_text_xy (slist[0], nlist[1], nlist[2], script);
	    returnint = sprite;
	    strcpy (s, h);
	    return (0);

	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "restart_game"))
      {
	int u, script;
	while (kill_last_sprite ());
	kill_repeat_sounds_all ();
	kill_all_scripts_for_real ();
	mode = 0;
	kill_all_vars ();
/* FillMemory (&hm, sizeof (hm), 0); */
	memset (&hm, 0, sizeof (hm));
	for (u = 1; u <= 10; u++)
	  play.button[u] = u;
	script = load_script ("main", 0, 1);

	locate (script, "main");
	run_script (script);
	/* lets attach our vars to the scripts */
	attach ();
	return (2);
      }

    if (compare (ev[1], "wait"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* Msg(("Wait called for %d.", nlist[0])); */
	    strcpy (s, h);
	    kill_returning_stuff (script);
	    /* int cb1 =  */
	    add_callback ("", nlist[0], 0,
			  script);

	    return (2);
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "preload_seq"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    check_seq_status (nlist[0]);
	  }

	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "script_attach"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    rinfo[script]->sprite = nlist[0];
	  }
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "draw_hard_sprite"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int l;
	    struct rect mhard;

	    update_play_changes ();
	    l = nlist[0];

	    CopyRect (&mhard,
		      &k[seq[spr[l].pseq].frame[spr[l].pframe]].hardbox);
	    OffsetRect (&mhard, (spr[l].x - 20), spr[l].y);

	    fill_hardxy (mhard);
	    fill_back_sprites ();
	    fill_hard_sprites ();


	  }
	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "move"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    spr[nlist[0]].move_active = 1;
	    spr[nlist[0]].move_dir = nlist[1];
	    spr[nlist[0]].move_num = nlist[2];
	    spr[nlist[0]].move_nohard = nlist[3];
	    spr[nlist[0]].move_script = 0;
	    if (debug_mode)
	      Msg (("Moving: Sprite %ld, dir %ld, num %ld", nlist[0], nlist[1],
		    nlist[2]));


	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "sp_script"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 2, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int tempreturn;
	    if (nlist[0] == 0)
	      {
		Msg (("Error: sp_script cannot process sprite 0??"));
		return (0);
	      }
	    kill_scripts_owned_by (nlist[0]);
	    if (load_script (slist[1], nlist[0], 1) == 0)
	      {
		returnint = 0;
		return (0);
	      }
	    if (no_running_main == 1)
	      Msg (("Not running %s until later..",
		    rinfo[spr[nlist[0]].script]->name));

	    if (no_running_main == 0)
	      locate (spr[nlist[0]].script, "MAIN");


	    tempreturn = spr[nlist[0]].script;

	    if (no_running_main == 0)
	      run_script (spr[nlist[0]].script);


	    returnint = tempreturn;
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "spawn"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int mysc = load_script (slist[0], 1000, 1);
	    int tempreturn;

	    if (mysc == 0)
	      {
		returnint = 0;
		return (0);
	      }
	    locate (mysc, "MAIN");
	    tempreturn = mysc;

	    run_script (mysc);
	    returnint = tempreturn;
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "run_script_by_number"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 2, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    locate (nlist[0], slist[1]);

	    run_script (nlist[0]);

	  }

	strcpy (s, h);
	return (0);
      }



    if (compare (ev[1], "draw_hard_map"))
      {
	/* (sprite, direction, until, nohard); */
	Msg (("Drawing hard map.."));
	update_play_changes ();
	fill_whole_hard ();
	fill_hard_sprites ();
	fill_back_sprites ();
	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "draw_background"))
      {
	/* (sprite, direction, until, nohard); */
	draw_map_game_background ();
	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "fade_down"))
      {
	/* (sprite, direction, until, nohard); */
	Msg (("fade_down"));
	process_downcycle = 1;
	/* Setup the temporary palette */
	memcpy (pe, real_pal, sizeof (SDL_Color) * 256);
	cycle_clock = thisTickCount + 1000;
	cycle_script = script;
	return (2);
      }
    if (compare (ev[1], "fade_up"))
      {
	/* (sprite, direction, until, nohard); */
	h = &h[strlen (ev[1])];
	Msg (("fade_up"));
	process_upcycle = 1;
	memset (pe, 0, sizeof (SDL_Color) * 256);
	cycle_script = script;

	strcpy (s, h);
	return (2);
      }


    if (compare (ev[1], "kill_this_task"))
      {
	/* (sprite, direction, until, nohard); */
	if (rinfo[script]->proc_return != 0)
	  {
	    run_script (rinfo[script]->proc_return);
	  }
	kill_script (script);
	return (2);
      }

    if (compare (ev[1], "kill_game"))
      {
	/* (sprite, direction, until, nohard); */

	Msg (("Was told to kill game, so doing it like a good boy."));
	/* PostMessage(hWndMain, WM_CLOSE, 0, 0); */
	finiObjects ();
	return (2);
      }


    if (compare (ev[1], "playavi"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* DSDisable(); */


	    /* ShowWindow(hWndMain, SW_MINIMIZE); */

	    /* SABETTS: nope */
/* int myreturn = */
/* _spawnl (_P_WAIT, "../dplay.exe", */
/* "../dplay.exe", slist[0], */
/* NULL); */

/* Msg( ("Return is %d", myreturn)); */
	    /* ShowWindow(hWndMain, SW_MAXIMIZE); */

	    /* SetFocus(hWndMain); */
	  }
	/* InitSound(hWndMain); */
	strcpy (s, h);
	return (2);

      }
    if (compare (ev[1], "playmidi"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* StopMidi(); */
	    int regm = atol (slist[0]);

	    Msg (("Processing playmidi command."));
	    if (regm > 1000)
	      {
		Msg (("playmidi - cd play command detected."));

		/* cd directive */

		if (cd_inserted)
		  {
		    if (regm == last_cd)
		      if (cdplaying ())
			return (2);
		    Msg (("Playing CD track %d.", regm - 1000));

		    PlayCD (regm - 1000);
		    strcpy (s, h);
		    return (0);
		  }
		else
		  {
		    char hold[255];

		    /* cd isn't instered, can't play CD song!!! */
		    sprintf (hold, "%d.mid", regm - 1000);
		    PlayMidi (hold);
		  }
	      }

	    PlayMidi (slist[0]);
	  }

	strcpy (s, h);
	return (0);
      }
    if (compare (ev[1], "stopmidi"))
      {
	/* (sprite, direction, until, nohard); */
	h = &h[strlen (ev[1])];
	StopMidi ();
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "kill_all_sounds"))
      {
	kill_repeat_sounds_all ();
	strcpy (s, h);
	return (0);

      }

    if (compare (ev[1], "turn_midi_off"))
      {
	midi_active = 0;
	strcpy (s, h);
	return (0);

      }
    if (compare (ev[1], "turn_midi_on"))
      {
	midi_active = 1;
	strcpy (s, h);
	return (0);

      }


    if (compare (ev[1], "Playsound"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (sound_on)
	      returnint =
		SoundPlayEffect (nlist[0], nlist[1], nlist[2], nlist[3],
				 nlist[4]);
	    else
	      returnint = 0;

	  }
	else
	  returnint = 0;

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "sound_set_survive"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (sound_on)
	      {
		/* let's set one sound to survive */
		if (nlist[0] > 0)
		  soundinfo[nlist[0]].survive = nlist[1];
	      }
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "sound_set_vol"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (sound_on)
	      {
		/* let's set one sound to survive */
		if (nlist[0] > 0)
		  {
		    soundinfo[nlist[0]].vol = nlist[1];

		    /* SABETTS: todo */
/* soundbank[nlist[0]]-> */
/* SetVolume (nlist[1]); */
		  }
	      }
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "sound_set_kill"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (sound_on)
	      {
		/* let's set one sound to survive */
		if (nlist[0] > 0)

		  {		/* SABETTS todo */
/* soundbank[nlist[0]]->Stop (); */
		  }
	      }
	  }

	strcpy (s, h);
	return (0);
      }



    if (compare (ev[1], "save_game"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    save_game (nlist[0]);
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "force_vision"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	Msg (("force_vision"));
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    int tmp;

	    *pvision = nlist[0];
	    /* When draw_map_game is called, it */
	    /* runs all the scripts at some point */
	    /* which runs through the script we're */
	    /* currently going through. So save */
	    /* the current location in the script, */
	    /* call draw_map_grame and then */
	    /* restore the current location so we */
	    /* can continue parsing. -sabetts */
	    tmp = rinfo[script]->current;
	    rinfo[script]->sprite = 1000;

	    fill_whole_hard ();
	    draw_map_game ();

	    rinfo[script]->current = tmp;
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "fill_screen"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    fill_screen (nlist[0]);

	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "load_game"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    kill_all_scripts_for_real ();
	    returnint = load_game (nlist[0]);
	    Msg (("load completed. "));
	    if (rinfo[script] == NULL)
	      Msg (("Script %d is suddenly null!", script));


	    *pupdate_status = 1;
	    draw_status_all ();
	    return (2);
	  }

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "game_exist"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    sprintf (temp, "save%ld.dat", nlist[0]);
	    if (exist (temp))
	      returnint = 1;
	    else
	      returnint = 0;

	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "move_stop"))
      {
	/* (sprite, direction, until, nohard); */
	int p[20] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* Msg(("Move stop running %d to %d..", nlist[0], nlist[0])); */
	    spr[nlist[0]].move_active = 1;
	    spr[nlist[0]].move_dir = nlist[1];
	    spr[nlist[0]].move_num = nlist[2];
	    spr[nlist[0]].move_nohard = nlist[3];
	    spr[nlist[0]].move_script = script;
	    strcpy (s, h);
	    if (debug_mode)
	      Msg (("Move_stop: Sprite %ld, dir %ld, num %ld", nlist[0],
		    nlist[1], nlist[2]));
	    return (2);

	  }

	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "load_sound"))
      {
	int p[20] = { 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    if (sound_on)
	      {
		Msg (("getting %s..", slist[0]));
		CreateBufferFromWaveFile (slist[0], nlist[1]);
	      }
	  }

	strcpy (s, h);
	return (0);
      }




    if (compare (ev[1], "debug"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    decipher_string (slist[0], script);
	    Msg ((slist[0]));
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "goto"))
      {

	locate_goto (ev[2], script);
	return (0);
      }



    if (compare (ev[1], "make_global_int"))
      {
	int p[20] = { 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    make_int (slist[0], nlist[1], 0, script);
	    /* Msg((slist[0])); */
	  }

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "int"))
      {

	int_prepare (h, script);

	/* Msg((slist[0])); */

	h = &h[strlen (ev[1])];

	/* Msg(("Int is studying %s..", h)); */
	if (strchr (h, '=') != NULL)
	  {
	    strip_beginning_spaces (h);
	    /* Msg(("Found =...continuing equation")); */
	    strcpy (s, h);
	    return (4);
	  }

	return (0);

      }



    if (compare (ev[1], "busy"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	/* Msg(("Running busy, h is %s", h)); */
	if (get_parms (ev[1], script, h, p))
	  {
	    if (nlist[0] == 0)
	      Msg (("ERROR:  Busy cannot get info on sprite 0 in %s.",
		    rinfo[script]->name));
	    else
	      {
		returnint = does_sprite_have_text (nlist[0]);
		Msg (("Busy: Return int is %d and %d.  Nlist got %ld.",
		      returnint, does_sprite_have_text (nlist[0]), nlist[0]));

	      }

	  }
	else
	  Msg (("Failed getting parms for Busy()"));

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "inside_box"))
      {
	int p[20] = { 1, 1, 1, 1, 1, 1, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	Msg (("Running pigs with h"));
	if (get_parms (ev[1], script, h, p))
	  {

	    struct rect myrect;

	    SetRect (&myrect, nlist[2], nlist[3], nlist[4], nlist[5]);
	    returnint = inside_box (nlist[0], nlist[1], myrect);

	    if (debug_mode)
	      Msg (("Inbox is int is %d and %ld.  Nlist got %ld.", returnint,
		    nlist[0], nlist[1]));



	  }
	else
	  Msg (("Failed getting parms for inside_box"));

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "random"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = (rand () % nlist[0]) + nlist[1];
	  }
	else
	  Msg (("Failed getting parms for Random()"));

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "initfont"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    initfonts (slist[0]);
	    Msg (("Initted font %s", slist[0]));
	  }
	else
	  Msg (("Failed getting parms for Initfont()"));

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[1], "get_version"))
      {
	h = &h[strlen (ev[1])];
	returnint = DVERSION;
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "get_burn"))
      {
	h = &h[strlen (ev[1])];
	returnint = burn_revision;
	strcpy (s, h);
	return (0);
      }



    if (compare (ev[1], "set_mode"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    mode = nlist[0];
	    returnint = mode;
	  }
	else
	  Msg (("Failed to set mode"));

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[1], "kill_shadow"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int jj;
	    for (jj = 1; jj <= last_sprite_created; jj++)
	      {
		if (spr[jj].brain == 15)
		  if (spr[jj].brain_parm == nlist[0])
		    {

		      spr[jj].active = 0;
		    }


	      }
	  }

	strcpy (s, h);
	return (0);
      }



    if (compare (ev[1], "create_sprite"))
      {
	int p[20] = { 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    returnint =
	      add_sprite_dumb (nlist[0], nlist[1], nlist[2], nlist[3],
			       nlist[4], 100);

	    return (0);
	  }
	returnint = 0;
	return (0);
      }



    if (compare (ev[1], "sp"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int ii;
	    for (ii = 1; ii <= last_sprite_created; ii++)
	      {

		if (spr[ii].sp_index == nlist[0])
		  {

		    if (debug_mode)
		      Msg (("Sp returned %d.", ii));
		    returnint = ii;
		    return (0);
		  }

	      }
	    if (last_sprite_created == 1)
	      {
		Msg (("warning - you can't call SP() from a screen-ref, no sprites have been created yet."));
	      }

	  }
	returnint = 0;
	return (0);
      }


    if (compare (ev[1], "is_script_attached"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {


	    returnint = spr[nlist[0]].script;

	  }
	return (0);
      }



    if (compare (ev[1], "sp_speed"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].speed);

	    if (nlist[1] != -1)
	      changedir (spr[nlist[0]].dir, nlist[0],
			 spr[nlist[0]].base_walk);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_range"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].range);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_nocontrol"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].nocontrol);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_nodraw"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].nodraw);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_picfreeze"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].picfreeze);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "get_sprite_with_this_brain"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int i;
	    for (i = 1; i <= last_sprite_created; i++)
	      {
		if ((spr[i].brain == nlist[0]) && (i != nlist[1]))
		  if (spr[i].active == 1)
		    {
		      Msg (("Ok, sprite with brain %ld is %d", nlist[0], i));
		      returnint = i;
		      return (0);
		    }

	      }
	  }
	Msg (("Ok, sprite with brain %ld is 0", nlist[0]));

	returnint = 0;
	return (0);
      }


    if (compare (ev[1], "get_rand_sprite_with_this_brain"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int cter = 0;
	    int mypick;
	    int i, ii;
	    for (i = 1; i <= last_sprite_created; i++)
	      {
		if ((spr[i].brain == nlist[0]) && (i != nlist[1]))
		  if (spr[i].active == 1)
		    {
		      cter++;

		    }

	      }

	    if (cter == 0)
	      {
		Msg (("Get rand brain can't find any brains with %ld.",
		      nlist[0]));
		returnint = 0;
		return (0);
	      }

	    mypick = (rand () % cter) + 1;

	    cter = 0;
	    for (ii = 1; ii <= last_sprite_created; ii++)
	      {
		if ((spr[ii].brain == nlist[0]) && (ii != nlist[1]))
		  if (spr[ii].active == 1)
		    {
		      cter++;
		      if (cter == mypick)
			{
			  returnint = ii;
			  return (0);
			}
		    }

	      }


	  }


	returnint = 0;
	return (0);
      }



    if (compare (ev[1], "sp_sound"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].sound);

	    if (nlist[1] != 0)
	      {
		SoundPlayEffect (spr[nlist[0]].sound, 22050, 0, nlist[0], 1);

	      }
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_attack_wait"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    returnint =
	      change_sprite (nlist[0], nlist[1] + thisTickCount,
			     &spr[nlist[0]].attack_wait);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_active"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].active);


	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_disabled"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].disabled);


	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_size"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].size);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }
    if (compare (ev[1], "activate_bow"))
      {

	spr[1].seq = 0;
	spr[1].pseq = 100 + spr[1].dir;
	spr[1].pframe = 1;
	bow.active = 1;
	bow.script = script;
	bow.hitme = 0;
	bow.time = 0;

	/*      bowsound->Release();

	   lpDS->DuplicateSoundBuffer(ssound[42].sound,&bowsound);
	   bowsound->Play(0, 0, DSBPLAY_LOOPING);
	 */

	return (2);
      }

    if (compare (ev[1], "get_last_bow_power"))
      {


	returnint = bow.last_power;
	return (0);
      }


    if (compare (ev[1], "sp_que"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].que);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_gold"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].gold);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "sp_base_walk"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite_noreturn (nlist[0], nlist[1],
				      &spr[nlist[0]].base_walk);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_target"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].target);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "stopcd"))
      {
/* mciSendCommand (CD_ID, MCI_CLOSE, 0, NULL); */
	Msg (("Stopped cd"));
	killcd (1);
	return (0);
      }


    if (compare (ev[1], "sp_base_hit"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite_noreturn (nlist[0], nlist[1],
				      &spr[nlist[0]].base_hit);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_base_attack"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite_noreturn (nlist[0], nlist[1],
				      &spr[nlist[0]].base_attack);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_base_idle"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite_noreturn (nlist[0], nlist[1],
				      &spr[nlist[0]].base_idle);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if ((compare (ev[1], "sp_base_die"))
	|| (compare (ev[1], "sp_base_death")))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite_noreturn (nlist[0], nlist[1],
				      &spr[nlist[0]].base_die);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "disable_all_sprites"))
      {
	int jj;
	for (jj = 1; jj < last_sprite_created; jj++)
	  if (spr[jj].active)
	    spr[jj].disabled = 1;
	return (0);
      }
    if (compare (ev[1], "enable_all_sprites"))
      {
	int jj;
	for (jj = 1; jj < last_sprite_created; jj++)
	  if (spr[jj].active)
	    spr[jj].disabled = 0;
	return (0);
      }


    if (compare (ev[1], "sp_pseq"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].pseq);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_pframe"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].pframe);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_seq"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].seq);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "editor_type"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    /* Msg(("Setting editor_type..")); */
	    returnint =
	      change_edit_char (nlist[0], nlist[1],
				&play.spmap[*pmap].type[nlist[0]]);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }
    if (compare (ev[1], "editor_seq"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_edit (nlist[0], nlist[1],
			   &play.spmap[*pmap].seq[nlist[0]]);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "editor_frame"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_edit_char (nlist[0], nlist[1],
				&play.spmap[*pmap].frame[nlist[0]]);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "sp_editor_num"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = spr[nlist[0]].sp_index;
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_brain"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].brain);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_exp"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].exp);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }
    if (compare (ev[1], "set_button"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    play.button[nlist[0]] = nlist[1];

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_reverse"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].reverse);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_noclip"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].noclip);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_touch_damage"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite_noreturn (nlist[0], nlist[1],
				      &spr[nlist[0]].touch_damage);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "sp_brain_parm"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].brain_parm);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }
    if (compare (ev[1], "sp_brain_parm2"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].brain_parm2);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_follow"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].follow);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "sp_frame"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].frame);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_frame_delay"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].frame_delay);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "hurt"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {

	    if (hurt_thing (nlist[0], nlist[1], 0) > 0)
	      random_blood (spr[nlist[0]].x, spr[nlist[0]].y - 40, nlist[0]);
	    if (spr[nlist[0]].nohit != 1)
	      if (spr[nlist[0]].script != 0)

		if (locate (spr[nlist[0]].script, "HIT"))
		  {

		    if (rinfo[script]->sprite != 1000)
		      *penemy_sprite = rinfo[script]->sprite;

		    kill_returning_stuff (spr[nlist[0]].script);
		    run_script (spr[nlist[0]].script);
		  }

	    return (0);
	  }
	returnint = -1;
	return (0);
      }







    if (compare (ev[1], "sp_hard"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].hard);
	    if (spr[nlist[0]].sp_index != 0)
	      if (nlist[1] != -1)
		{

		  pam.sprite[spr[nlist[0]].sp_index].hard = returnint;
		}
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_move_nohard"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].move_nohard);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }
    if (compare (ev[1], "sp_flying"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].flying);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }




    if (compare (ev[1], "sp_kill_wait"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    spr[nlist[0]].wait = 0;
	    return (0);
	  }
	returnint = -1;
	return (0);
      }
    if (compare (ev[1], "sp_kill"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    spr[nlist[0]].kill = nlist[1];
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "screenlock"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    screenlock = nlist[0];
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "stop_entire_game"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    struct rect rcRect;
	    stop_entire_game = nlist[0];
/* while (1) { */

	    SetRect (&rcRect, 0, 0, 640, 480);
/* ddrval = lpDDSTwo->BltFast (0, 0, */
/* lpDDSBack, */
/* &rcRect, */
/* DDBLTFAST_NOCOLORKEY); */
	    BltFast (lpDDSTwo, 0, 0, lpDDSBack, &rcRect);

/* if (ddrval == DD_OK) { */
/* break; */
/* } */
/* if (ddrval != DDERR_WASSTILLDRAWING) { */
/* dderror (ddrval); */
/* return (0); */
/* } */
/* } */










	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "dink_can_walk_off_screen"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    walk_off_screen = nlist[0];
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "push_active"))
      {
	int p[20] = { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    push_active = nlist[0];
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_x"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = change_sprite (nlist[0], nlist[1], &spr[nlist[0]].x);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "count_item"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int i;
	    returnint = 0;
	    for (i = 1; i < 17; i++)
	      {
		if (play.item[i].active)
		  {
		    if (compare (play.item[i].name, slist[0]))
		      returnint++;
		  }

	      }

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "count_magic"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int i;
	    returnint = 0;
	    for (i = 1; i < 9; i++)
	      {
		if (play.mitem[i].active)
		  {
		    if (compare (play.mitem[i].name, slist[0]))
		      returnint++;
		  }

	      }

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_mx"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = change_sprite (nlist[0], nlist[1], &spr[nlist[0]].mx);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_my"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = change_sprite (nlist[0], nlist[1], &spr[nlist[0]].my);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "scripts_used"))
      {
	int m = 0;
	int i;
	h = &h[strlen (ev[1])];

	for (i = 1; i < MAX_SCRIPTS; i++)
	  if (rinfo[i] != NULL)
	    m++;
	returnint = m;
	return (0);
      }




    if (compare (ev[1], "sp_dir"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].dir);

	    if (nlist[1] != -1)
	      changedir (spr[nlist[0]].dir, nlist[0],
			 spr[nlist[0]].base_walk);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_hitpoints"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].hitpoints);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_attack_hit_sound"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     &spr[nlist[0]].attack_hit_sound);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_attack_hit_sound_speed"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     &spr[nlist[0]].attack_hit_sound_speed);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_strength"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].strength);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "sp_defense"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].defense);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }

    if (compare (ev[1], "init"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {

	    figure_out (slist[0], 0);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_distance"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].distance);

	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_nohit"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].nohit);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_notouch"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1],
			     (int *) &spr[nlist[0]].notouch);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }



    if (compare (ev[1], "compare_weapon"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = 0;
	    if (*pcur_weapon == 0)
	      {
		return (0);
	      }

	    if (compare (play.item[*pcur_weapon].name, slist[0]))
	      {
		returnint = 1;

	      }
	    return (0);
	  }


	return (0);
      }


    if (compare (ev[1], "compare_magic"))
      {
	int p[20] = { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = 0;
	    if (*pcur_magic == 0)
	      {
		return (0);
	      }

	    if (compare (play.item[*pcur_magic].name, slist[0]))
	      {
		returnint = 1;

	      }
	    return (0);
	  }


	return (0);
      }


    if (compare (ev[1], "compare_sprite_script"))
      {
	int p[20] = { 1, 2, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = 0;

	    if (nlist[0] == 0)
	      {
		Msg (("Error: Can't compare sprite script for sprite 0?!"));
		return (0);
	      }
	    if (spr[nlist[0]].active)
	      {

		if (spr[nlist[0]].script == 0)
		  {
		    Msg (("Compare sprite script says: Sprite %ld has no script.", nlist[0]));
		    return (0);
		  }
		if (compare (slist[1], rinfo[spr[nlist[0]].script]->name))
		  {
		    returnint = 1;
		    return (0);
		  }

	      }
	    else
	      {
		Msg (("Can't compare sprite script, sprite not active."));
	      }



	    return (0);
	  }


	return (0);
      }


    if (compare (ev[1], "sp_y"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint = change_sprite (nlist[0], nlist[1], &spr[nlist[0]].y);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "sp_timing"))
      {
	int p[20] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];	if (get_parms (ev[1], script, h, p))
	  {
	    returnint =
	      change_sprite (nlist[0], nlist[1], &spr[nlist[0]].timer);
	    return (0);
	  }
	returnint = -1;
	return (0);
      }


    if (compare (ev[1], "return;"))
      {

	if (debug_mode)
	  Msg (("Found return; statement"));

	if (rinfo[script]->proc_return != 0)
	  {
	    run_script (rinfo[script]->proc_return);
	    kill_script (script);
	  }

	return (2);
      }




    if (compare (ev[1], "if"))
      {

	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	/* Msg(("running if with string of %s", h)); */

	process_line (script, h, 0);
	/* Msg(("Result is %d", returnint)); */

	if (returnint != 0)
	  {
	    if (debug_mode)
	      Msg (("If returned true"));


	  }
	else
	  {
	    /* don't do it! */
	    rinfo[script]->skipnext = 1;
	    if (debug_mode)
	      Msg (("If returned false, skipping next thing"));
	  }

	/* DO STUFF HERE! */
	strcpy (s, h);
	/* g("continuing to run line %s..", h); */


	return (5);

      }



    if (compare (ev[2], "="))
      {
	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	h = &h[1];
	strip_beginning_spaces (h);
	var_equals (ev[1], ev[3], '=', script, h);
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[2], "+="))
      {
	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	h = &h[2];
	strip_beginning_spaces (h);
	var_equals (ev[1], ev[3], '+', script, h);
	strcpy (s, h);
	return (0);
      }

    if (compare (ev[2], "*="))
      {
	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	h = &h[2];
	strip_beginning_spaces (h);
	var_equals (ev[1], ev[3], '*', script, h);
	strcpy (s, h);
	return (0);
      }



    if (compare (ev[2], "-="))
      {
	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	h = &h[2];
	strip_beginning_spaces (h);

	var_equals (ev[1], ev[3], '-', script, h);

	strcpy (s, h);
	return (0);
      }


    if (compare (ev[2], "/"))
      {
	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	h = &h[1];
	strip_beginning_spaces (h);

	var_equals (ev[1], ev[3], '/', script, h);

	strcpy (s, h);
	return (0);
      }

    if (compare (ev[2], "*"))
      {
	h = &h[strlen (ev[1])];
	strip_beginning_spaces (h);
	h = &h[1];
	strip_beginning_spaces (h);

	var_equals (ev[1], ev[3], '*', script, h);

	strcpy (s, h);
	return (0);
      }
    if (compare (ev[1], "external"))
      {
	int p[20] = { 2, 2, 0, 0, 0, 0, 0, 0, 0, 0 };
	h = &h[strlen (ev[1])];
	if (get_parms (ev[1], script, h, p))
	  {
	    int myscript1 = load_script (slist[0],
					 rinfo[script]->sprite,
					 0);

	    if (myscript1 == 0)
	      {
		Msg (("Error:  Couldn't find %s.c (for procedure %s)",
		      slist[0], slist[1]));
		return (0);
	      }
	    if (locate (myscript1, slist[1]))
	      {
		rinfo[myscript1]->proc_return = script;
		run_script (myscript1);

		return (2);
	      }
	    else
	      {
		Msg (("Error:  Couldn't find procedure %s in %s.", slist[1],
		      slist[0]));
		kill_script (myscript1);
	      }
	  }
	strcpy (s, h);
	return (0);
      }


    if (strchr (h, '(') != NULL)
      {
	int myscript;

	/* lets attempt to run a procedure */
	seperate_string (h, 1, '(', line);
	myscript = load_script (rinfo[script]->name,
				    rinfo[script]->sprite, 0);

	if (locate (myscript, line))
	  {
	    rinfo[myscript]->proc_return = script;
	    run_script (myscript);
	    return (2);
	  }
	else
	  {
	    Msg (("ERROR:  Procedure void %s( void ); not found in script %s. (word 2 was %s) ", line, ev[2], rinfo[myscript]->name));
	    kill_script (myscript);
	  }


	return (0);

      }

    Msg (("MERROR: \"%s\" unknown in %s, offset %ld.", ev[1],
	  rinfo[script]->name, rinfo[script]->current));

    /* in a thingie, ready to go */

  }

bad:
  strcpy (s, h);
  return (0);

good:
  strcpy (s, h);
  /* s = h */
  /* Msg(("ok, continuing with running %s..",s)); */
  return (1);

}


void
make_int (char name[80], int value, int scope, int script)
{
  int dupe;


  if (strlen (name) > 19)
    {

      Msg (("ERROR:  Varname %s is too long in script %s.", name,
	    rinfo[script]->name));
      return;
    }
  dupe = var_exists (name, scope);

  if (dupe > 0)
    {
      if (scope != 0)
	{
	  Msg (("Local var %s already used in this procedure in script %s.",
		name, rinfo[script]->name));

	  play.var[dupe].var = value;

	}
      else
	Msg (("Var %s is already a global, not changing value.", name));

      return;
    }

  /* make new var */
  {
    int i;
    for (i = 1; i < MAX_VARS; i++)
      {
	if (play.var[i].active == 0)
	  {
	    
	    play.var[i].active = 1;
	    play.var[i].scope = scope;
	    strcpy (play.var[i].name, name);
	    /* g("var %s created, used slot %d ", name,i); */
	    play.var[i].var = value;
	    return;
	  }
      }
  }

  Msg (("ERROR: Out of var space, all %d used.", MAX_VARS));
}


/**
 * Init or change a variable
 * TODO
 * @param math '=', '+', '-', '/' or '*'
 */
int
var_equals (char name[20], char newname[20], char math, int script,
	    char rest[200])
{
  int k;
  int newret/*;*/ = 0;
  int i;

  if (name[0] != '&')
    {
      Msg (("ERROR (var equals): Unknown var %s in %s offset %ld.", name,
	    rinfo[script]->name, rinfo[script]->current));
      return (0);
    }

  for (i = 1; i < MAX_VARS; i++)
    {
      if (play.var[i].active == 1)
	{

	  if ((play.var[i].scope == 0) | (play.var[i].scope == script))
	    if (compare (name, play.var[i].name))
	      {
		/* found var */
		goto next;
	      }
	}
    }

  Msg (("ERROR: (var equals2) Unknown var %s in %s offset %ld.", name,
	rinfo[script]->name, rinfo[script]->current));
  return (0);

next:
  {
    int newval = 0;

    if (strchr (rest, '(') != NULL)
      {
	newret = process_line (script, rest, 0);
	newval = returnint;
	goto next2;
      }

    if (strchr (newname, ';') != NULL)
      replace (";", "", newname);
    for (k = 1; k < MAX_VARS; k++)
      {
	if (play.var[k].active == 1)
	  {
	    if ((play.var[i].scope == 0) | (play.var[i].scope == script))
	      if (compare (newname, play.var[k].name))
		{
		  newval = play.var[k].var;
		  /* found var */
		  goto next2;
		}
	  }
      }
    
    if (compare (newname, "&current_sprite"))
      {
	newval = rinfo[script]->sprite;
	goto next2;
      }
    
    if (compare (newname, "&current_script"))
      {
	newval = script;
	goto next2;
      }
    newval = atol (newname);

  next2:
    if (math == '=')
      play.var[i].var = newval;
    
    if (math == '+')
      play.var[i].var += newval;
    
    if (math == '-')
      play.var[i].var -= newval;
    
    if (math == '/')
      play.var[i].var = play.var[i].var / newval;
    
    if (math == '*')
      play.var[i].var = play.var[i].var * newval;
  }

  return (newret);
}


void
get_word (char line[300], int word, char *crap)
{
  int cur = 0;
  int k;

  /*bool*/int space_mode = 0;
  char save_word[100];

  save_word[0] = 0;

  for (k = 0; k < strlen (line); k++)
    {
      if (space_mode == 1)
	{
	  if (line[k] != ' ')
	    {
	      space_mode = 0;
	      strcpy (save_word, "");

	    }
	}



      if (space_mode == 0)
	{
	  if (line[k] == ' ')
	    {
	      cur++;
	      if (word == cur)
		goto done;
	      space_mode = 1;
	      strcpy (save_word, "");

	      goto dooba;
	    }
	  else
	    {
	      strchar (save_word, line[k]);

	    }
	}


    dooba:;

    }

  if (space_mode == 0)
    {

      if (cur + 1 != word)
	strcpy (save_word, "");
    }


done:

  strcpy (crap, save_word);

  /* Msg(("word %d of %s is %s.", word, line, crap)); */
}




int
var_figure (char h[200], int script)
{
  char crap[200];
  int ret = 0;
  int n1 = 0, n2 = 0;

  /* Msg(("Figuring out %s...", h)); */
  get_word (h, 2, crap);
  /* Msg(("Word two is %s...", crap)); */

  if (compare (crap, ""))
    {
      /* one word equation */

      if (h[0] == '&')
	{
	  /* its a var possibly */
	  decipher_string (h, script);
	}
      /* Msg(("truth is %s", h)); */
      ret = atol (h);
      /* Msg(("returning %d, happy?", ret)); */
      return (ret);
    }

  /*  */


  get_word (h, 1, crap);
  /* Msg(("Comparing %s...", crap)); */

  decipher_string (crap, script);
  n1 = atol (crap);

  get_word (h, 3, crap);
  replace (")", "", crap);
  /* Msg(("to  %s...", crap)); */
  decipher_string (crap, script);
  n2 = atol (crap);

  get_word (h, 2, crap);
  if (debug_mode)
    Msg (("Compared %d to %d", n1, n2));

  if (compare (crap, "=="))
    {
      if (n1 == n2)
	ret = 1;
      else
	ret = 0;
      return (ret);
    }

  if (compare (crap, ">"))
    {
      if (n1 > n2)
	ret = 1;
      else
	ret = 0;
      return (ret);
    }

  if (compare (crap, ">="))
    {
      if (n1 >= n2)
	ret = 1;
      else
	ret = 0;
      return (ret);
    }


  if (compare (crap, "<"))
    {
      if (n1 < n2)
	ret = 1;
      else
	ret = 0;
      return (ret);
    }
  if (compare (crap, "<="))
    {
      if (n1 <= n2)
	ret = 1;
      else
	ret = 0;
      return (ret);
    }

  if (compare (crap, "!="))
    {
      if (n1 != n2)
	ret = 1;
      else
	ret = 0;
      return (ret);
    }

  return (ret);

}


void
kill_text_owned_by (int sprite)
{
  int i;
  for (i = 1; i < MAX_SPRITES_AT_ONCE; i++)
    {
      if (spr[i].active)
	if (spr[i].brain == 8)
	  if (spr[i].owner == sprite)
	    {
	      spr[i].active = 0;


	    }
    }

}

/*bool*/int
text_owned_by (int sprite)
{
  int i;
  for (i = 1; i < MAX_SPRITES_AT_ONCE; i++)
    {
      if (spr[i].active)
	if (spr[i].brain == 8)
	  if (spr[i].owner == sprite)
	    {

	      return (1);



	    }
    }
  return (0);
}


void
kill_text_owned_by_safe (int sprite)
{
  int i;
  for (i = 1; i < MAX_SPRITES_AT_ONCE; i++)
    {
      if (spr[i].active)
	if (spr[i].brain == 8)
	  if (spr[i].owner == sprite)
	    {
	      spr[i].active = 0;

	      if (spr[i].callback != 0)
		run_script (spr[i].callback);
	    }
    }

}




void
kill_scripts_owned_by (int sprite)
{
  int i;
  for (i = 1; i < MAX_SCRIPTS; i++)
    {
      if (rinfo[i] != NULL)
	{
	  if (rinfo[i]->sprite == sprite)
	    {
	      kill_script (i);

	    }

	}
    }

}

void
kill_sprite_all (int sprite)
{
  spr[sprite].active = 0;

  kill_text_owned_by (sprite);
  kill_scripts_owned_by (sprite);

}


void
kill_returning_stuff (int script)
{
  int i;
  /* Msg(("Checking callbacks..")); */
  /* check callbacks */
  for (i = 1; i < MAX_CALLBACKS; i++)
    {
      if (callback[i].active)
	if (callback[i].owner == script)
	  /* if (compare(callback[i].name, "")) */
	  {
	    Msg (("killed a returning callback, ha!"));
	    callback[i].active = 0;
	  }

    }


  for (i = 1; i <= last_sprite_created; i++)
    {
      if (spr[i].active)
	if (spr[i].brain == 8)
	  if (spr[i].callback == script)
	    {
	      Msg (("Killed sprites callback command"));
	      spr[i].callback = 0;
	    }

    }

}




/*bool*/int
talk_get (int script)
{
  char line[200], check[200], checker[200];
  int cur = 1;
  char *p;
/* UNREFERENCED   int num; */
  int retnum = 0;

  clear_talk ();
  talk.newy = -5000;
  while (1)
    {
    redo:

      read_next_line (script, line);



      strip_beginning_spaces (line);
      /* Msg(("Comparing to %s.", line)); */

      get_word (line, 1, checker);

      if (compare (checker, "set_y"))
	{

	  get_word (line, 2, checker);
	  talk.newy = atol (checker);

	  goto redo;
	}

      if (compare (checker, "set_title_color"))
	{

	  get_word (line, 2, checker);
	  talk.color = atol (checker);
	  goto redo;
	}


      if (compare (line, "\n"))
	goto redo;
      if (compare (line, "\\\\"))
	goto redo;


      strip_beginning_spaces (line);
      /* Msg(("Comparing to %s.", line)); */
      if (compare (line, "\n"))
	goto redo;
      if (compare (line, "\\\\"))
	goto redo;

    morestuff:

      seperate_string (line, 1, '(', check);
      strip_beginning_spaces (check);

      if (compare (check, "title_start"))
	{

	  while (read_next_line (script, line))
	    {

	      strcpy (check, line);
	      strip_beginning_spaces (line);
	      get_word (line, 1, checker);
	      seperate_string (line, 1, '(', check);
	      strip_beginning_spaces (check);

	      if (compare (check, "title_end"))
		{
		  replace ("\n\n\n\n", "\n \n", talk.buffer);

		  replace ("\n\n", "\n", talk.buffer);

		  goto redo;
		}

	      line[strlen (line)] = 0;
	      /* Msg(("LINE IS: %s: Like it?",line)); */

	      decipher_string (line, script);
	      strcat (talk.buffer, line);
	      /* talk.buffer[strlen(talk.buffer)-1] = 0; */
	    }

	  goto redo;
	}

      if (compare (check, "choice_end"))
	{
	  if (cur - 1 == 0)
	    {
	      Msg (("Error: choice() has 0 options in script %s, offset %ld.",
		    rinfo[script]->name, rinfo[script]->current));

	      return (0);
	    }
	  /* all done, lets jam */
	  /* Msg(("found choice_end, leaving!")); */
	  talk.last = cur - 1;
	  talk.cur = 1;
	  talk.active = 1;
	  talk.page = 1;
	  talk.cur_view = 1;
	  talk.script = script;
	  return (1);

	}



      seperate_string (line, 1, '\"', check);
      strip_beginning_spaces (check);

      /* Msg(("Check is %s.",check)); */

      if (strlen (check) > 2)
	{
	  /* found conditional statement */
	  if (strchr (check, '(') == NULL)
	    {
	      Msg (("Error with choice() statement in script %s, offset %ld. (%s?)", rinfo[script]->name, rinfo[script]->current, check));
	      return (0);
	    }

	  seperate_string (check, 2, '(', checker);
	  seperate_string (checker, 1, ')', check);

	  /* Msg(("Running %s through var figure..", check)); */
	  if (var_figure (check, script) == 0)
	    {
	      Msg (("Answer is no."));
	      retnum++;
	      goto redo;
	      /* said NO to statement */
	    }
	  /* Msg(("Answer is yes.")); */
	  seperate_string (line, 1, ')', check);

	  p = &line[strlen (check) + 1];

	  strcpy (check, p);


	  strcpy (line, check);

	  /* Msg(("new line is %s, happy?", line)); */
	  goto morestuff;
	}



      seperate_string (line, 2, '\"', check);
      strip_beginning_spaces (check);
      /* Msg(("Line %d is %s.",cur,check)); */
      retnum++;
      decipher_savegame = retnum;
      decipher_string (check, script);
      decipher_savegame = 0;
      strcpy (talk.line[cur], check);
      talk.line_return[cur] = retnum;
      cur++;
    }

}

void
get_right (char line[200], char thing[100], char *ret)
{
  char *dumb;
  int pos = strcspn (line, thing);


  if (pos == 0)
    {
      strcpy (ret, "");
      return;
    }


  dumb = &ret[pos + 1];
  strcpy (ret, dumb);
}




void
int_prepare (char line[100], int script)
{
  int def = 0;
  char hold[100];
  char name[100];
  char crap[100];

  strcpy (hold, line);

  replace ("=", " ", line);
  strcpy (crap, line);
  seperate_string (crap, 1, ';', line);
  get_word (line, 2, name);

  if (name[0] != '&')
    {
      Msg (("ERROR:  Can't create var %s, should be &%s.", name, name));
      return;
    }


  make_int (name, def, script, script);

  strcpy (line, hold);

}


int
change_sprite (int h, int val, int *change)
{
  /* Msg(("Searching sprite %s with val %d.  Cur is %d", h, val, *change)); */

  if (h < 1)
    {
      Msg (("Error with an SP command - Sprite %d is invalid.", h));
      return (-1);
    }
  if (spr[h].active == 0)
    return (-1);
  if (val != -1)
    {
      *change = val;
    }

  return (*change);

}

int
change_edit (int h, int val, unsigned short *change)
{
  /* Msg(("Searching sprite %s with val %d.  Cur is %d", h, val, *change)); */

  if (h > 99)
    return (-1);
  if (h < 1)
    return (-1);
  if (val != -1)
    {
      *change = val;
    }

  return (*change);

}

int
change_edit_char (int h, int val, unsigned char *change)
{
  /* Msg(("Searching sprite %s with val %d.  Cur is %d", h, val, *change)); */
  /* Msg(("h is %d..",val)); */
  if (h > 99)
    return (-1);
  if (h < 1)
    return (-1);
  if (val != -1)
    {
      *change = val;
    }

  return (*change);

}


int
change_sprite_noreturn (int h, int val, int *change)
{
  /* Msg(("Searching sprite %s with val %d.  Cur is %d", h, val, *change)); */
  if (spr[h].active == 0)
    return (-1);

  {
    *change = val;
  }

  return (*change);

}


void
changedir (int dir1, int k, int base)
{
  int hspeed;
  int speed_hold = spr[k].speed;
  int old_seq;

  if (k > 1)
    if (spr[k].brain != 9)
      if (spr[k].brain != 10)
	{

	  /* if (mbase_timing > 20) mbase_timing = 20; */

	  /* Msg((",base_timing is %d", base_timing)); */
	  hspeed = spr[k].speed * (base_timing / 4);
	  if (hspeed > 49)
	    {
	      Msg (("Speed was %d", hspeed));
	      spr[k].speed = 49;
	    }
	  else
	    spr[k].speed = hspeed;
	}
  old_seq = spr[k].seq;

  spr[k].dir = dir1;

  if (dir1 == 1)
    {
      spr[k].mx = (0 - spr[k].speed) + (spr[k].speed / 3);
      spr[k].my = spr[k].speed - (spr[k].speed / 3);

      if (base != -1)
	{


	  spr[k].seq = base + 1;
	  if (seq[spr[k].seq].active == 0)
	    {
	      spr[k].seq = base + 9;

	    }

	}

      if (old_seq != spr[k].seq)
	{
	  spr[k].frame = 0;
	  spr[k].delay = 0;
	}


    }

  if (dir1 == 2)
    {
      spr[k].mx = 0;
      spr[k].my = spr[k].speed;
      if (base != -1)
	spr[k].seq = base + 2;

      if (seq[spr[k].seq].active == 0)
	if (seq[base + 3].active)
	  spr[k].seq = base + 3;
      if (seq[spr[k].seq].active == 0)
	if (seq[base + 1].active)
	  spr[k].seq = base + 1;


      if (old_seq != spr[k].seq)
	{
	  spr[k].frame = 0;
	  spr[k].delay = 0;
	}


    }
  if (dir1 == 3)
    {
      spr[k].mx = spr[k].speed - (spr[k].speed / 3);
      spr[k].my = spr[k].speed - (spr[k].speed / 3);
      if (base != -1)
	{
	  spr[k].seq = base + 3;
	  if (seq[spr[k].seq].active == 0)
	    spr[k].seq = base + 7;

	}

      if (old_seq != spr[k].seq)
	{
	  spr[k].frame = 0;
	  spr[k].delay = 0;
	}


    }

  if (dir1 == 4)
    {

      /* Msg(("Changing %d to four..",k)); */
      spr[k].mx = (0 - spr[k].speed);
      spr[k].my = 0;
      if (base != -1)
	spr[k].seq = base + 4;
      if (seq[spr[k].seq].active == 0)
	if (seq[base + 7].active)
	  spr[k].seq = base + 7;
      if (seq[spr[k].seq].active == 0)
	if (seq[base + 1].active)
	  spr[k].seq = base + 1;
    }

  if (dir1 == 6)
    {
      spr[k].mx = spr[k].speed;
      spr[k].my = 0;
      if (base != -1)
	spr[k].seq = base + 6;

      if (seq[spr[k].seq].active == 0)
	if (seq[base + 3].active)
	  spr[k].seq = base + 3;
      if (seq[spr[k].seq].active == 0)
	if (seq[base + 9].active)
	  spr[k].seq = base + 9;

    }

  if (dir1 == 7)
    {
      spr[k].mx = (0 - spr[k].speed) + (spr[k].speed / 3);
      spr[k].my = (0 - spr[k].speed) + (spr[k].speed / 3);
      if (base != -1)
	{
	  spr[k].seq = base + 7;


	  if (seq[spr[k].seq].active == 0)
	    {

	      spr[k].seq = base + 3;
	    }
	}

    }
  if (dir1 == 8)
    {
      spr[k].mx = 0;
      spr[k].my = (0 - spr[k].speed);
      if (base != -1)
	spr[k].seq = base + 8;

      if (seq[spr[k].seq].active == 0)
	if (seq[base + 7].active)
	  spr[k].seq = base + 7;
      if (seq[spr[k].seq].active == 0)
	if (seq[base + 9].active)
	  spr[k].seq = base + 9;

    }


  if (dir1 == 9)
    {
      spr[k].mx = spr[k].speed - (spr[k].speed / 3);
      spr[k].my = (0 - spr[k].speed) + (spr[k].speed / 3);
      if (base != -1)
	{
	  spr[k].seq = base + 9;
	  if (seq[spr[k].seq].active == 0)
	    {
	      spr[k].seq = base + 1;
	    }
	}
    }



  if (old_seq != spr[k].seq)
    {
      spr[k].frame = 0;
      spr[k].delay = 0;
    }


  if (seq[spr[k].seq].active == 0)
    {
      /* spr[k].mx = 0; */
      /* spr[k].my = 0; */
      spr[k].seq = old_seq;

    }
  /* Msg(("Leaving with %d..", spr[k].dir)); */

  /* Msg(("Changedir: Tried to switch sprite %d to dir %d",k,dir1)); */

  spr[k].speed = speed_hold;

}


void
update_play_changes (void)
{
  int j;
  for (j = 1; j < 100; j++)
    {
      if (pam.sprite[j].active)
	if (play.spmap[*pmap].type[j] != 0)
	  {
	    /* lets make some changes, player has extra info */
	    if (play.spmap[*pmap].type[j] == 1)
	      {
		pam.sprite[j].active = 0;

	      }

	    if (play.spmap[*pmap].type[j] == 2)
	      {
		pam.sprite[j].type = 1;
		pam.sprite[j].hard = 1;
	      }
	    if (play.spmap[*pmap].type[j] == 3)
	      {

		/* Msg(("Changing sprite %d", j)); */
		pam.sprite[j].type = 0;
		pam.sprite[j].hard = 1;

	      }

	    if (play.spmap[*pmap].type[j] == 4)
	      {
		pam.sprite[j].type = 1;
		pam.sprite[j].hard = 0;
	      }

	    if (play.spmap[*pmap].type[j] == 5)
	      {
		pam.sprite[j].type = 0;
		pam.sprite[j].hard = 0;
	      }

	    if (play.spmap[*pmap].type[j] == 6)
	      {
		pam.sprite[j].active = 0;

	      }
	    if (play.spmap[*pmap].type[j] == 7)
	      {
		pam.sprite[j].active = 0;

	      }
	    if (play.spmap[*pmap].type[j] == 8)
	      {
		pam.sprite[j].active = 0;

	      }

	    pam.sprite[j].seq = play.spmap[*pmap].seq[j];
	    pam.sprite[j].frame = play.spmap[*pmap].frame[j];
	    strcpy (pam.sprite[j].script, "");


	  }


    }
}

void
update_status_all (void)
{
  /*bool*/int drawexp = 0;
  int next;
  int script;
  
  next = next_raise();
  if (next != fraise)
    {
      fraise += next / 40;

      if (fraise > next)
	fraise = next;
      /* make noise here */
      drawexp = 1;
      SoundPlayEffect (13, 15050, 0, 0, 0);


    }

  if (*pexper != fexp)
    {
      /* update screen experience */
      fexp += 10;
      /* make noise here */

      if (fexp > *pexper)
	fexp = *pexper;
      drawexp = 1;
      SoundPlayEffect (13, 29050, 0, 0, 0);

      if (fexp >= fraise)
	{

	  *pexper -= next;
	  fexp = 0;

	  script = load_script ("lraise", 1, 0);
	  if (locate (script, "raise"))
	    run_script (script);
	}
    }



  if (drawexp)
    {


      draw_exp ();
    }


  if ((flifemax != *plifemax) || (flife != *plife))
    {
      if (flifemax < *plifemax)
	flifemax++;
      if (flifemax > *plifemax)
	flifemax--;
      if (flife > *plife)
	flife--;
      if (flife < *plife)
	flife++;
      if (flife > *plife)
	flife--;
      if (flife < *plife)
	flife++;
      draw_bar (flifemax, 190);
      draw_bar (flife, 451);
    }

  if (fstrength != *pstrength)
    {
      if (fstrength < *pstrength)
	fstrength++;
      if (fstrength > *pstrength)
	fstrength--;
      SoundPlayEffect (22, 22050, 0, 0, 0);

      draw_strength ();
    }

  if (fdefense != *pdefense)
    {
      if (fdefense < *pdefense)
	fdefense++;
      if (fdefense > *pdefense)
	fdefense--;
      SoundPlayEffect (22, 22050, 0, 0, 0);
      draw_defense ();
    }
  if (fmagic != *pmagic)
    {
      if (fmagic < *pmagic)
	fmagic++;
      if (fmagic > *pmagic)
	fmagic--;
      SoundPlayEffect (22, 22050, 0, 0, 0);
      draw_magic ();
    }

  if (fgold != *pgold)
    {
      if (fgold < *pgold)
	{
	  fgold += 20;
	  if (fgold > *pgold)
	    fgold = *pgold;
	}

      if (fgold > *pgold)
	{
	  fgold -= 20;
	  if (fgold < *pgold)
	    fgold = *pgold;
	}
      SoundPlayEffect (14, 22050, 0, 0, 0);
      draw_gold ();
    }

  if (*pmagic_level < *pmagic_cost)
    {
      if (item_screen == 0)
	*pmagic_level += *pmagic;
      if (*pmagic_level > *pmagic_cost)
	*pmagic_level = *pmagic_cost;
    }
  if (*pmagic_cost > 0)
    if (*pmagic_level > 0)
      {
	int mnum = *pmagic_level / (*pmagic_cost / 100);

	if (mnum != last_magic_draw)
	  {

	    draw_mlevel (mnum);

	    /* draw_status_all(); */
	    last_magic_draw = mnum;


	  }
      }


  spr[1].strength = fstrength;
  spr[1].defense = fdefense;


  if (flife < 1)
    {
      script = load_script ("dinfo", 1000, 0);
      if (locate (script, "die"))
	run_script (script);
    }

}


void
run_script (int script)
{
  int result;
  char line[200];

  returnint = 0;
  returnstring[0] = 0;
  if (rinfo[script] != NULL)
    {
      if (debug_mode)
	Msg (("Script %s is entered at offset %ld.", rinfo[script]->name,
	      rinfo[script]->current));
    }
  else
    {
      Msg (("Error:  Tried to run a script that doesn't exist in memory.  Nice work."));
    }

  while (read_next_line (script, line))
    {

      while (1)
	{
	  strip_beginning_spaces (line);
	  if (compare (line, "\n"))
	    break;


	  result = process_line (script, line, 0);
	  if (result == 3)
	    {
	    redo:
	      read_next_line (script, line);
	    crappa:
	      strip_beginning_spaces (line);
	      if (compare (line, "\n"))
		goto redo;
	      if (compare (line, "\\\\"))
		goto redo;
	      /* Msg(("processing %s knowing we are going to skip it...", line)); */
	      result = process_line (script, line, 1);
	    }

	  if (result == 5)
	    goto crappa;

	  if (result == 3)
	    {
	      goto redo;
	    }

	  if (result == 2)
	    {
	      if (debug_mode)
		Msg (("giving script the boot"));
	      /* quit script */
	      return;
	    }
	  if (result == 0)
	    break;

	  if (result == 4)
	    {

	      /* Msg(("Was sent %s, length %d", line, strlen(line))); */

	      if (strlen (line) < 2)
		{
		redo2:

		  read_next_line (script, line);
		  strip_beginning_spaces (line);
		  /* Msg(("Comparing to %s.", line)); */
		  if (compare (line, "\n"))
		    goto redo2;
		  if (compare (line, "\\\\"))
		    goto redo2;
		}
	      result = process_line (script, line, 1);
	    }

	  if (result == 2)
	    {
	      if (debug_mode)
		Msg (("giving script the boot"));
	      /* quit script */
	      return;
	    }
	  if (result == 0)
	    break;
	}
    }

  if (rinfo[script] != NULL)
    {
      if (rinfo[script]->proc_return != 0)
	{
	  run_script (rinfo[script]->proc_return);
	  kill_script (script);
	}
    }
}

void
process_callbacks (void)
{
/* int thist = GetTickCount (); */
  int thist = SDL_GetTicks ();

  int i, k;
  for (i = 1; i < MAX_SCRIPTS; i++)
    {
      if (rinfo[i] != NULL)
	{
	  if (rinfo[i]->sprite > 0)
	    if (rinfo[i]->sprite != 1000)
	      if (spr[rinfo[i]->sprite].active == 0)
		{
		  /* kill this script, owner is dead */
		  if (debug_mode)
		    Msg (("Killing script %s, owner sprite %d is dead.",
			  rinfo[i]->name, rinfo[i]->sprite));
		  kill_script (i);
		  /*free(rinfo[i]);
		     rinfo[i] = NULL;
		     free(rbuf[i]);
		     rbuf[i] = NULL; */
		}
	}
    }

  for (k = 1; k < MAX_CALLBACKS; k++)
    {
      if (callback[k].active)
	{
	  if (callback[k].owner > 0)
	    {
	      if (rinfo[callback[k].owner] == NULL)
		{
		  /* kill this process, it's owner sprite is 'effin dead. */
		  if (debug_mode)
		    Msg (("Killed callback #%d because script %d is dead.", k,
			  callback[k].owner));
		  callback[k].active = 0;
		}
	      else
		{
		  if (callback[k].timer == 0)
		    {
		      /* set timer */
		      if (callback[k].max > 0)
			callback[k].timer =
			  thist + (rand () % callback[k].max) + callback[k].min;
		      else
			callback[k].timer = thist + callback[k].min;
		    }
		  else
		    {
		      if (callback[k].timer < thist)
			{
			  callback[k].timer = 0;
			  if (compare (callback[k].name, ""))
			    {
			      /* callback defined no proc name, so lets assume they want to start the script where it */
			      /* left off */
			      /* kill this callback */
			      callback[k].active = 0;
			      run_script (callback[k].owner);
			      if (debug_mode)
				Msg (("Called script %d with callback %d.",
				      callback[k].owner, k));
			    }
			  else
			    {
			      if (debug_mode)
				Msg (("Called proc %s with callback %d.",
				      callback[k].name, k));
			      
			      /* callback defined a proc name */
			      if (locate (callback[k].owner, callback[k].name))
				{
				  /* found proc, lets run it */
				  run_script (callback[k].owner);
				}
			    }
			}
		    }
		}
	    }
	}
    }
}




void
init_scripts (void)
{
  int k;
  for (k = 1; k < MAX_SCRIPTS; k++)
    {
      if ((rinfo[k] != NULL)
	  && (rinfo[k]->sprite != 0)
	  /* && or || ?? Should sprite #1000 always executed, or
	     ignored? */
	  && (rinfo[k]->sprite != 1000)
	  && (spr[rinfo[k]->sprite].active)
	  && (locate (k, "main")))
	{
	  if (debug_mode)
	    Msg (("Screendraw: running main of script %s..",
		  rinfo[k]->name));
	  run_script (k);
	}
    }
}

void
init_sprites ()
{
  k = (struct pic_info *) calloc (MAX_SPRITES, sizeof (struct pic_info));
  if (k == NULL)
    {
      Msg (("Unable to init k structure"));
      exit (1);
    }

  spr = (struct sp *) calloc (MAX_SPRITES_AT_ONCE, sizeof (struct sp));
  if (spr == NULL)
    {
      Msg (("Unable to init spr structure"));
      exit (1);
    }

  seq = (struct sequence *) calloc (MAX_SEQUENCES, sizeof (struct sequence));
  if (seq == NULL)
    {
      Msg (("Unable to init seq structure"));
      exit (1);
    }

  sequence_index =
    (struct sprite_index *) calloc (MAX_SEQUENCES, sizeof (struct sprite_index));
  if (sequence_index == NULL)
    {
      Msg (("Unable to init sequence_index structure"));
      exit (1);
    }
}
