/**
 * Loaders and savers for several kind of data

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2003, 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/dinkio.c,v 1.2 2004/01/05 08:55:45 Beuc Exp $
 */

#include <time.h>
#include "dink.h"

void
load_map (const int num)
{
  FILE *fp;
  long holdme, lsize;

  /* rect box; */
  /* play.map = num; */
  /* Msg(("Loading map %d...",num)); */

  fp = fopen (current_map, "rb");
  if (!fp)
    {
      Msg (("Cannot find %s file!!!", current_map));
      return;
    }
  lsize = sizeof (struct small_map);
  holdme = (lsize * (num - 1));
  fseek (fp, holdme, SEEK_SET);
  /* Msg(("Trying to read %d bytes with offset of %d",lsize,holdme)); */
  {
    int shit = fread (&pam, lsize, 1, fp);	/* current player */
    
    /* Msg(("Read %d bytes.",shit)); */
    if (shit == 0)
      Msg (("ERROR:  Couldn't read map %d?!?", num));
    fclose (fp);
  }

  spr[1].move_active = 0;
  spr[1].freeze = 0;
  screenlock = 0;
  fill_whole_hard ();
  fix_dead_sprites ();


  if (!dinkedit)
    check_midi ();

  /* draw_map_game(); */
}

void
save_map (const int num)
{
  FILE *fp;
  long holdme, lsize;
  char crap[80];


  Msg (("Saving map data.."));
  strcpy (crap, current_map);
  if (num > 0)
    {
      fp = fopen (crap, "r+b");
      lsize = sizeof (struct small_map);
      holdme = (lsize * (num - 1));
      fseek (fp, holdme, SEEK_SET);
      fwrite (&pam, lsize, 1, fp);	/* current player */
      fclose (fp);

    }


  Msg (("Done saving map data.."));

}




void
save_info (void)
{
  FILE *fp;
  char crap[80];

  sprintf (crap, "dink.dat");
  fp = fopen (crap, "wb");
  fwrite (&map, sizeof (struct map_info), 1, fp);
  fclose (fp);
}

void
save_game (int num)
{
  FILE *fp;
  char crap[80];
  time_t ct;

  /* lets set some vars first */

  play.x = spr[1].x;
  play.y = spr[1].y;
  play.version = DVERSION;
  play.pseq = spr[1].pseq;
  play.pframe = spr[1].pframe;
  play.seq = spr[1].seq;
  play.frame = spr[1].frame;
  play.size = spr[1].size;
  play.dir = spr[1].dir;
  play.strength = spr[1].strength;
  play.defense = spr[1].defense;
  play.que = spr[1].que;


  time (&ct);
  play.minutes += (int) (difftime (ct, time_start) / 60);
  /* reset timer */
  time (&time_start);

  play.base_idle = spr[1].base_idle;
  play.base_walk = spr[1].base_walk;
  play.base_hit = spr[1].base_hit;

  sprintf (play.gameinfo, "Level %d", *plevel);


  last_saved_game = num;
  sprintf (crap, "save%d.dat", num);
  fp = fopen (crap, "wb");
  fwrite (&play, sizeof (play), 1, fp);
  fclose (fp);


}


/*bool*/int
add_time_to_saved_game (int num)
{
  FILE *fp;
  char crap[80];

  sprintf (crap, "save%d.dat", num);

  fp = fopen (crap, "rb");
  if (!fp)
    {
      Msg (("Couldn't load save game %d", num));
      return (0);
    }
  else
    {

      fread (&play, sizeof (play), 1, fp);
      fclose (fp);


    }


  /* great, now let's resave it with added time */
  {
    time_t ct;
    Msg (("Ok, adding time."));
    
    time (&ct);
    play.minutes += (int) (difftime (ct, time_start) / 60);
  }



  sprintf (crap, "save%d.dat", num);
  fp = fopen (crap, "wb");
  if (fp)
    {
      fwrite (&play, sizeof (play), 1, fp);
      fclose (fp);
    }
  Msg (("Wrote it.(%d of time)", play.minutes));

  return (1);
}




/*bool*/int
load_game (int num)
{
  FILE *fp;
  char crap[80];

  /* lets get rid of our magic and weapon scripts */
  if (weapon_script != 0)
    {

      if (locate (weapon_script, "DISARM"))
	{
	  run_script (weapon_script);
	}
      else
	{
	}

    }
  if (magic_script != 0)
    if (locate (magic_script, "DISARM"))
      run_script (magic_script);





  bow.active = 0;
  weapon_script = 0;
  magic_script = 0;
  midi_active = 1;


  if (last_saved_game > 0)
    {
      Msg (("Modifying saved game."));

      if (!add_time_to_saved_game (last_saved_game))
	Msg (("Error modifying saved game."));
    }
  StopMidi ();

  sprintf (crap, "save%d.dat", num);



  fp = fopen (crap, "rb");
  if (!fp)
    {
      Msg (("Couldn't load save game %d", num));
      return (0);
    }
  else
    {

      fread (&play, sizeof (play), 1, fp);
      fclose (fp);

      spr[1].damage = 0;
      spr[1].x = play.x;
      spr[1].y = play.y;
      walk_off_screen = 0;
      spr[1].nodraw = 0;
      push_active = 1;
      spr[1].pseq = play.pseq;
      spr[1].pframe = play.pframe;
      spr[1].size = play.size;
      spr[1].seq = play.seq;
      spr[1].frame = play.frame;
      spr[1].dir = play.dir;
      spr[1].strength = play.strength;
      spr[1].defense = play.defense;
      spr[1].que = play.que;

      time (&time_start);

      spr[1].base_idle = play.base_idle;
      spr[1].base_walk = play.base_walk;
      spr[1].base_hit = play.base_hit;

      {
	int script = load_script ("main", 0, 1);
	
	locate (script, "main");
	run_script (script);
      }
      /* lets attach our vars to the scripts */

      attach ();
      Msg (("Attached vars."));

      if (*pcur_weapon != 0)
	{
	  if (play.item[*pcur_weapon].active == 0)
	    {
	      *pcur_weapon = 1;
	      weapon_script = 0;
	      Msg (("Loadgame error: Player doesn't have armed weapon - changed to 1."));
	    }
	  else
	    {

	      weapon_script =
		load_script (play.item[*pcur_weapon].name, 1000, 0);


	      if (locate (weapon_script, "DISARM"))
		run_script (weapon_script);

	      weapon_script =
		load_script (play.item[*pcur_weapon].name, 1000, 0);


	      if (locate (weapon_script, "ARM"))
		run_script (weapon_script);
	    }
	}
      if (*pcur_magic != 0)
	{
	  if (play.item[*pcur_magic].active == 0)
	    {
	      *pcur_magic = 0;
	      magic_script = 0;
	      Msg (("Loadgame error: Player doesn't have armed magic - changed to 0."));
	    }
	  else
	    {

	      magic_script =
		load_script (play.mitem[*pcur_magic].name, 1000, 0);
	      if (locate (magic_script, "DISARM"))
		run_script (magic_script);
	      magic_script =
		load_script (play.mitem[*pcur_magic].name, 1000, 0);
	      if (locate (magic_script, "ARM"))
		run_script (magic_script);
	    }
	}
      kill_repeat_sounds_all ();
      load_map (map.loc[*pmap]);
      Msg (("Loaded map."));
      draw_map_game ();
      Msg (("Map drawn."));

      last_saved_game = num;

      return (1);
    }

}





void
update_screen_time (void)
{
  /* Msg(("Cur time is %d", play.spmap[*pmap].last_time)); */
  /* Msg(("Map is %d..", *pmap)); */
  play.spmap[*pmap].last_time = thisTickCount;
  /* Msg(("Time was saved as %d", play.spmap[*pmap].last_time)); */
}

/*bool*/int
load_game_small (int num, char *line, int *mytime)
{
  FILE *fp;
  char crap[80];

  sprintf (crap, "save%d.dat", num);


  fp = fopen (crap, "rb");
  if (!fp)
    {
      Msg (("Couldn't quickload save game %d", num));
      return (0);
    }
  else
    {

      fread (&short_play, sizeof (struct player_short_info), 1, fp);
      fclose (fp);
      *mytime = short_play.minutes;
      strcpy (line, short_play.gameinfo);
      return (1);
    }

}


void
load_info (void)
{
  FILE *fp;
  char crap[80];

  sprintf (crap, "dink.dat");


  fp = fopen (crap, "rb");
  if (!fp)
    {
      /* fclose(fp); */
      fp = fopen (crap, "wb");
      /* make new data file */
      strcpy (map.name, "Smallwood");
      fwrite (&map, sizeof (struct map_info), 1, fp);
      fclose (fp);
    }
  else
    {
      Msg (("World data loaded."));
      fread (&map, sizeof (struct map_info), 1, fp);
      fclose (fp);

    }

}

void
save_hard (void)
{
  FILE *fp;
  char crap[80];

  sprintf (crap, "hard.dat");
  fp = fopen (crap, "wb");

  if (!fp)
    {

      Msg (("Couldn't save hard.dat for some reason.  Out of disk space?"));
    }
  fwrite (&hmap, sizeof (struct hardness), 1, fp);
  fclose (fp);
}


void
load_hard (void)
{
  FILE *fp;
  char crap[80];

  sprintf (crap, "hard.dat");
  if (!dinkedit)
    {
      if (!exist (crap))
	sprintf (crap, "../dink/hard.dat");
    }

  fp = fopen (crap, "rb");
  if (!fp)
    {
      /* fclose(fp); */
      fp = fopen (crap, "wb");
      /* make new data file */
/* ZeroMemory (&hmap, sizeof (struct hardness)); */
      memset (&hmap, 0, sizeof (struct hardness));
      fwrite (&hmap, sizeof (struct hardness), 1, fp);
      fclose (fp);
    }
  else
    {
      fread (&hmap, sizeof (struct hardness), 1, fp);
      fclose (fp);

    }

}


void
load_sprite_pak (char org[100], int nummy, int speed, int xoffset,
		 int yoffset, struct rect hardbox, /*bool*/int notanim, /*bool*/int black,
		 /*bool*/int leftalign, /*bool*/int samedir)
{
  int work;

  HFASTFILE pfile;

/* BITMAPFILEHEADER UNALIGNED *pbf; */
/* BITMAPINFOHEADER UNALIGNED *pbi; */
/* DDSURFACEDESC ddsd; */
/* HBITMAP hbm; */
/* BITMAP bm; */

/* DDCOLORKEY ddck; */


  /* UNREFERENCED int x, y, dib_pitch; */
  /* UNREFERENCED BYTE *src, *dst; */
  char fname[20];
/* UNREFERENCED   char *dump; */

  /* IDirectDrawSurface *pdds; */

  int sprite = 71;
  /* UNUSED  /\*BOOL*\/int trans = 0; */
  /*bool*/int reload = 0;

/* PALETTEENTRY holdpal[256]; */
  char crap[200];
  char crap2[200];
  /* UNREFERENCED char hold[5]; */

  int save_cur = cur_sprite;

  if (sequence_index[nummy].last != 0)
    {
      /* Msg(("Saving sprite %d", save_cur)); */
      cur_sprite = sequence_index[nummy].s + 1;
      /* Msg(("Temp cur_sprite is %d", cur_sprite)); */
      reload = 1;
    }


  sequence_index[nummy].s = cur_sprite - 1;

  if (no_running_main)
    draw_wait ();

  strcpy (crap2, org);
  while (crap2[strlen (crap2) - 1] != '/')
    {
      crap2[strlen (crap2) - 1] = 0;
    }
  crap2[strlen (crap2) - 1] = 0;

  {
    int num = strlen (org) - strlen (crap2) - 1;
    strcpy (fname, &org[strlen (org) - num]);
  }

  if (samedir)
    sprintf (crap, "%s/dir.ff", crap2);
  else
    sprintf (crap, "../dink/%s/dir.ff", crap2);


  if (!FastFileInit ((char *) crap, 5))
    {
      Msg (("Could not load dir.ff art file %s", crap));

      cur_sprite = save_cur;
      return;

    }

  if (cur_sprite > 10000)
    {
      Msg (("Bad stuff"));
    }

  /*           if (!windowed)
     {
     lpDDPal->GetEntries(0,0,256,holdpal);       
     lpDDPal->SetEntries(0,0,256,real_pal);
     }   
   */

  {
    int oo;
    for (oo = 1; oo <= 51; oo++)
      {
	
	
      /* load sprite */
	/* UNREFERENCED       char dumb[100]; */
	
	sprite = cur_sprite;
	/* if (reload) Msg(("Ok, programming sprite %d", sprite));       */
	if (oo < 10)
	  strcpy (crap2, "0");
	else
	  strcpy (crap2, "");
	sprintf (crap, "%s%s%d.bmp", fname, crap2, oo);
	
	pfile = FastFileOpen ((char *) crap);
	
	
	if (pfile == NULL)
	  {
	    FastFileClose (pfile);
	    /* FastFileFini(); */
	    if (oo == 1)
	      Msg (("Sprite_load_pak error:  Couldn't load %s.", crap));
	    
	    sequence_index[nummy].last = (oo - 1);
	    /* initFail(hWndMain, crap); */
	    setup_anim (nummy, nummy, speed);
	    /* if (!windowed)  lpDDPal->SetEntries(0,0,256,holdpal); */
	    
	    /* if (reload) Msg(("Ok, tacking %d back on.", save_cur)); */
	    cur_sprite = save_cur;
	    return;
	  }
	else
	  {
	    /* got file */
	    
	    Uint8 *buffer;
	    SDL_RWops *rw;
	    SDL_Surface *bmp_surf;
	    
	    buffer = (Uint8 *) FastFileLock (pfile, 0, 0);
	    rw = SDL_RWFromMem (buffer, FastFileLen (pfile));
	    
	    /* bmp_surf = SDL_LoadBMP_RW (rw, 0); */
	    bmp_surf = IMG_Load_RW (rw, 0);
	    if (bmp_surf == NULL)
	      {
		Msg (("unable to load %s from fastfile", crap));
	      }
	    
	    SDL_FreeRW (rw);
	    
	    if (k[sprite].k != NULL)
	      SDL_FreeSurface (k[sprite].k);
	    
	    if (black)
	      SDL_SetColorKey (bmp_surf, SDL_SRCCOLORKEY,
			       map_rgb (bmp_surf, 0, 0, 0));
	    else
	      SDL_SetColorKey (bmp_surf, SDL_SRCCOLORKEY,
			       map_rgb (bmp_surf, 255, 255, 255));
	    
	    k[sprite].k = SDL_DisplayFormat (bmp_surf);
	    if (k[sprite].k == NULL)
	      {
		Msg (("Unable to convert surface of %s: %s", crap,
		      SDL_GetError ()));
	      }
	    SDL_FreeSurface (bmp_surf);
	    
	    
	    if (sprite > 0)
	      {
		k[sprite].box.top = 0;
		k[sprite].box.left = 0;
		k[sprite].box.right = k[sprite].k->w;
		k[sprite].box.bottom = k[sprite].k->h;

		if ((oo > 1) & (notanim))
		  {
		    
		    k[cur_sprite].yoffset =
		      k[sequence_index[nummy].s + 1].yoffset;
		  }
		else
		  {
		    if (yoffset > 0)
		      k[cur_sprite].yoffset = yoffset;
		    else
		      {
			k[cur_sprite].yoffset =
			  (k[cur_sprite].box.bottom -
			   (k[cur_sprite].box.bottom / 4)) -
			  (k[cur_sprite].box.bottom / 30);
		      }
		  }
		
		if ((oo > 1) & (notanim))
		{
		  k[cur_sprite].xoffset =
		    k[sequence_index[nummy].s + 1].xoffset;
		}
		else
		  {
		    if (xoffset > 0)
		      k[cur_sprite].xoffset = xoffset;
		    else
		      {
			k[cur_sprite].xoffset =
			  (k[cur_sprite].box.right -
			   (k[cur_sprite].box.right / 2)) +
			  (k[cur_sprite].box.right / 6);
		      }
		  }
		/* ok, setup main offsets, lets build the hard block */
		
		if (hardbox.right > 0)
		  {
		    /* forced setting        */
		    k[cur_sprite].hardbox.left = hardbox.left;
		    k[cur_sprite].hardbox.right = hardbox.right;
		  }
		else
		  {
		    /* guess setting         */
		    work = k[cur_sprite].box.right / 4;
		    k[cur_sprite].hardbox.left -= work;
		    k[cur_sprite].hardbox.right += work;
		    
		  }
		
		if (hardbox.bottom > 0)
		  {
		    k[cur_sprite].hardbox.top = hardbox.top;
		    k[cur_sprite].hardbox.bottom = hardbox.bottom;
		    
		  }
		else
		  {
		    
		    work = k[cur_sprite].box.bottom / 10;
		    k[cur_sprite].hardbox.top -= work;
		    k[cur_sprite].hardbox.bottom += work;
		    
		  }
		
		cur_sprite++;
		if (!reload)
		  save_cur++;
		FastFileClose (pfile);
	      }
	    
	  }
      }
  }
}



void
load_sprites (char input_org[100], int nummy, int speed, int xoffset,
	      int yoffset, struct rect hardbox, /*bool*/int notanim, /*bool*/int black,
	      /*bool*/int leftalign)
{
  int work;


  char crap[200], crap2[200], hold[5];
  char org[100];

  /* In the case that input_org is a constant string, copy it */
  /* into our buffer so we can process it. */
  strncpy (org, input_org, 100);

  if (no_running_main)
    draw_wait ();

  Msg (("Loading %s...", org));
  process_string (org);
  Msg (("Processed to %s...", org));

  strcpy (crap2, org);
  /* FRONTSLASH */
  
  while (crap2[strlen (crap2) - 1] != '/')
    {
      crap2[strlen (crap2) - 1] = 0;
    }
  crap2[strlen (crap2) - 1] = 0;
  
  sprintf (crap, "%s/dir.ff", crap2);


  /* Msg(("Checking for %s..", crap)); */
  if (exist (crap))
    {
      load_sprite_pak (org, nummy, speed, xoffset, yoffset, hardbox, notanim,
		       black, leftalign, 1);
      return;
    }

  sprintf (crap, "%s01.bmp", org);
  if (!exist (crap))
    {

      sprintf (crap, "../dink/%s/dir.ff", crap2);
      /* Msg(("Checking for %s..", crap)); */
      if (exist (crap))
	{
	  load_sprite_pak (org, nummy, speed, xoffset, yoffset, hardbox,
			   notanim, black, leftalign, 0);
	  return;
	}



      /* Msg(("Dir bad for sprite, changing")); */
      sprintf (crap, "../dink/%s", org);
      strcpy (org, crap);

    }
  sequence_index[nummy].s = cur_sprite - 1;

  if (!windowed)
    {
      /* SABETTS: palette */
/* lpDDPal->GetEntries (0, 0, 256, holdpal); */
/* lpDDPal->SetEntries (0, 0, 256, real_pal); */
    }

  {
    int oo;
    for (oo = 1; oo <= 1000; oo++)
      {
	if (oo < 10)
	  strcpy (hold, "0");
	else
	  strcpy (hold, "");
	sprintf (crap, "%s%s%d.bmp", org, hold, oo);
	
	/* k[cur_sprite].k = DDSethLoad (crap, 0, 0, cur_sprite); */
	if (black)
	  k[cur_sprite].k = load_image (crap, 1, 0, 0, 0);
	else
	  k[cur_sprite].k = load_image (crap, 1, 255, 255, 255);
	
	if (k[cur_sprite].k != NULL)
	  {
	    k[cur_sprite].box.left = 0;
	    k[cur_sprite].box.top = 0;
	    k[cur_sprite].box.right = k[cur_sprite].k->w;
	    k[cur_sprite].box.bottom = k[cur_sprite].k->h;
	    if ((oo > 1) & (notanim))
	      {
		k[cur_sprite].yoffset = k[sequence_index[nummy].s + 1].yoffset;
	      }
	    else
	      {
		if (yoffset > 0)
		  k[cur_sprite].yoffset = yoffset;
		else
		  {
		    k[cur_sprite].yoffset =
		      (k[cur_sprite].box.bottom -
		       (k[cur_sprite].box.bottom / 4)) -
		      (k[cur_sprite].box.bottom / 30);
		  }
	      }
	    
	    if ((oo > 1) & (notanim))
	      {
		k[cur_sprite].xoffset = k[sequence_index[nummy].s + 1].xoffset;
	      }
	    else
	      {
		if (xoffset > 0)
		  k[cur_sprite].xoffset = xoffset;
		else
		  {
		    k[cur_sprite].xoffset =
		      (k[cur_sprite].box.right -
		       (k[cur_sprite].box.right / 2)) +
		      (k[cur_sprite].box.right / 6);
		  }
	      }
	    /* ok, setup main offsets, lets build the hard block */
	    
	    if (hardbox.right > 0)
	      {
		/* forced setting         */
		k[cur_sprite].hardbox.left = hardbox.left;
		k[cur_sprite].hardbox.right = hardbox.right;
	      }
	    else
	      {
		/* guess setting          */
		work = k[cur_sprite].box.right / 4;
		k[cur_sprite].hardbox.left -= work;
		k[cur_sprite].hardbox.right += work;
	      }
	    
	    if (hardbox.bottom > 0)
	      {
		k[cur_sprite].hardbox.top = hardbox.top;
		k[cur_sprite].hardbox.bottom = hardbox.bottom;
	      }
	    else
	      {
		work = k[cur_sprite].box.bottom / 10;
		k[cur_sprite].hardbox.top -= work;
		k[cur_sprite].hardbox.bottom += work;
	      }
	  }
	
	if (leftalign)
	  {
	    /* k[cur_sprite].xoffset = 0; */
	    /* k[cur_sprite].yoffset = 0; */
	  }
	/* add_text(crap,"LOG.TXT");    */
	
	if (k[cur_sprite].k == NULL)
	  {
	    if (oo < 2)
	      {
		Msg (("load_sprites:  Anim %s not found.", org));
	      }

	    sequence_index[nummy].last = (oo - 1);
	    /* initFail(hWndMain, crap); */
	    setup_anim (nummy, nummy, speed);
	    /* SABETTS: palette */
	    /* if (!windowed) */
	    /* lpDDPal->SetEntries (0, 0, 256, holdpal); */
	    return;
	  }
	cur_sprite++;
	/* if (first_frame) if  (oo == 1) return; */
      }
  } 
}

void
refigure_out (char line[255])
{
  char ev[15][100];
/*   int myseq = 0, myframe = 0; */
  int i;
/* UNREFERENCED   rect hardbox; */
/* ZeroMemory (&ev, sizeof (ev)); */

  memset (&ev, 0, sizeof (ev));

  for (i = 1; i <= 14; i++)
    {
      seperate_string (line, i, ' ', ev[i]);
      /* Msg(("Word %d is \"%s\"",i,ev[i])); */
    }

  if (compare (ev[1], "LOAD_SEQUENCE_NOW"))
    {
      /* name   seq    speed       offsetx     offsety       hardx      hardy        */
      /* reload_sprites(ev[2],atol(ev[3]),0); */
    }


}



void
reload_batch (void)
{
/* UNREFERENCED   int crapint; */

  FILE *stream;
  char line[255];

  Msg (("reoading .ini"));
  if (!exist ("dink.ini"))
    {
      Msg (("File not found."));

      /* sprintf(line,"Error finding the dink.ini file in the %s dir.",dir); */
      /* TRACE(line); */

    }




  if ((stream = fopen ("dink.ini", "r")) != NULL)
    {
      while (1)
	{
	  if (fgets (line, 255, stream) == NULL)
	    goto done;
	  else
	    {
	      refigure_out (line);
	    }
	}

    done:
      fclose (stream);
    }
  else
    {
      /* TRACE("Dink.ini missing."); */
    }

}


char *
decompress (FILE * in)
{
  char *cbuf;
  unsigned char stack[16], pair[128][2];
  short c, top = 0;

  cbuf = (char *) malloc (64000 * sizeof (char *));
  if (cbuf == NULL)
    {
      Msg (("Unable to alloc space"));
      exit (1);
    }
  cbuf[0] = 0;

  /* Check for optional pair count and pair table */
  if ((c = getc (in)) > 127)
    fread (pair, 2, c - 128, in);
  else
    {
      if (c == '\r')
	c = '\n';
      if (c == 9)
	c = ' ';

      strchar (cbuf, c);
    }
  /* putc(c,out); */

  for (;;)
    {

      /* Pop byte from stack or read byte from file */
      if (top)
	c = stack[--top];
      else if ((c = getc (in)) == EOF)
	break;

      /* Push pair on stack or output byte to file */
      if (c > 127)
	{
	  stack[top++] = pair[c - 128][1];
	  stack[top++] = pair[c - 128][0];
	}
      else
	{
	  if (c == '\r')
	    c = '\n';
	  if (c == 9)
	    c = ' ';

	  strchar (cbuf, c);	/* putc(c,out); */
	}
    }

  return cbuf;
}


char *
decompress_nocomp (FILE * in)
{
  char *cbuf;

  /* let's do it, only this time decompile OUR style */

  unsigned char stack[16], pair[128][2];
  short c, top = 0;

  cbuf = (char *) malloc (64000 * sizeof (char *));
  if (cbuf == NULL)
    {
      Msg (("Unable to alloc space"));
      exit (1);
    }
  cbuf[0] = 0;

  /* Check for optional pair count and pair table */
  if ((c = getc (in)) > 255)
    fread (pair, 2, c - 128, in);
  else
    {
      if (c == '\r')
	c = '\n';
      if (c == 9)
	c = ' ';

      strchar (cbuf, c);
    }
  /* putc(c,out); */

  for (;;)
    {

      /* Pop byte from stack or read byte from file */
      if (top)
	c = stack[--top];
      else if ((c = getc (in)) == EOF)
	break;

      /* Push pair on stack or output byte to file */
      if (c > 255)
	{
	  stack[top++] = pair[c - 128][1];
	  stack[top++] = pair[c - 128][0];
	}
      else
	{
	  if (c == '\r')
	    c = '\n';
	  if (c == 9)
	    c = ' ';

	  strchar (cbuf, c);	/* putc(c,out); */
	}
    }

  return cbuf;
}

int
load_script (char input_filename[15], int sprite, /*bool*/int set_sprite)
{
  char *cbuf;
  char temp[100];
  int script;
  FILE *stream;
/* UNREFERENCED   int fh; */
  /*bool*/int comp = 0;
  char tab[10];
/* UNREFERENCED   char line[500]; */
  char filename[15];
  int j;

  strncpy (filename, input_filename, 15);

  Msg (("Loading script %s", filename));
  process_string (filename);
  Msg (("Processed to %s", filename));

  sprintf (tab, "%c", 9);

  /* SABETTS: (change) Load the uncompressed file before the */
  sprintf (temp, "story/%s.c", filename);

  if (!exist (temp))
    {


      sprintf (temp, "story/%s.d", filename);
      if (!exist (temp))
	{


	  sprintf (temp, "../dink/story/%s.c", filename);
	  if (!exist (temp))
	    {
	      sprintf (temp, "../dink/story/%s.d", filename);
	      if (!exist (temp))
		{

		  Msg (("Script %s not found. (checked for .C and .D) (requested by %d?)", temp, sprite));
		  return (0);
		}
	    }
	}



    }
/*   else */
/*     { */

/*     } */

/* strupr (temp); */
  Msg (("Temp thingie is %c", temp[strlen (temp) - 1]));
  if (temp[strlen (temp) - 1] == 'd')
    comp = 1;
  else
    comp = 0;


  for (j = 1; j < MAX_SCRIPTS; j++)
    {
      if (rbuf[j] == NULL)
	{
	  /* found one not being used */
	  goto found;
	}
    }

  Msg (("Couldn't find unused buffer for script."));
  return (0);

  Msg (("Loading script %s..", temp));
found:


  Msg (("Found space for script at %d", j));

  script = j;

  rinfo[script] = (struct refinfo *) malloc (sizeof (struct refinfo));

  memset (rinfo[script], 0, sizeof (struct refinfo));


  /* if compiled */
  {
    /* load compiled script */
    if ((stream = fopen (temp, "rb")) == NULL)
      {
	Msg (("Script %s not found. (checked for .C and .D) (requested by %d?)", temp, sprite));
	return (0);
      }

/* cbuf[0] = 0; */
    /* Msg(("decompressing!")); */

    if (comp)
      cbuf = decompress (stream);
    else
      cbuf = decompress_nocomp (stream);

    fclose (stream);

    /* Msg(("done decompressing!")); */

    /* file is now in cbuf!! */

    rinfo[script]->end = (strlen (cbuf)) + 1;
    /* Msg(("dlength is %d!", rinfo[script]->end));                             */

    rbuf[script] = (char *) malloc (rinfo[script]->end);

    /* rbuf[script] = new [script]->end; */


    if (rbuf[script] == NULL)
      {

	Msg (("Couldn't allocate rbuff %d.", script));
	return (0);
      }


/* CopyMemory (rbuf[script], &cbuf, rinfo[script]->end); */
    memcpy (rbuf[script], cbuf, rinfo[script]->end);
    free (cbuf);

    if (rinfo[script] == NULL)
      {

	Msg (("Couldn't allocate rscript %d.", script));
	return (0);
      }


  }
  /* Msg(("Script %s loaded by sprite %d into space %d.",temp, sprite,script)); */
  strcpy (rinfo[script]->name, filename);
  rinfo[script]->sprite = sprite;


  if (set_sprite)
    {
      if (sprite != 0)
	if (sprite != 1000)
	  spr[sprite].script = script;
    }
  return (script);

}
