/**
   SSLRecord.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Fri May  7 17:26:42 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLRecord.java,v 1.4 1999/06/22 06:24:55 ekr Exp $

*/

package COM.claymoresystems.ptls;
import java.io.*;

// This class only does plaintext right now
class SSLRecord extends SSLPDU
{
     SSLuint8 type=new SSLuint8();
     SSLuint16 version=new SSLuint16();
     SSLopaque data=new SSLopaque(-65535);

     public static final int SSL_CT_CHANGE_CIPHER_SPEC = 20;
     public static final int SSL_CT_ALERT = 21;
     public static final int SSL_CT_HANDSHAKE = 22;
     public static final int SSL_CT_APPLICATION_DATA = 23;
     
     public SSLRecord(SSLConn conn,int ct,byte[] buf){
       type.value=ct;
       version.value=conn.ssl_version;
       data.value=buf;
     }

     
     public SSLRecord(SSLConn conn){
       ;
     }
       
     public int encode(SSLConn conn,OutputStream s)
       throws Error,java.io.IOException {
       int written=0;

       written=type.encode(conn,s);
       written+=version.encode(conn,s);

       if(conn.write_cipher_state!=null){
	 byte[] encrypted;
	 int length=data.value.length;
	 int pad=0;
	 SSLCipherSuite cs;

	 cs=conn.write_cipher_state.cipher_suite;
	 length+=cs.getDigestOutputLength();

	 SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"Encrypting: plain text",
	   data.value);
	 if(cs.blockCipherP()){
	   length++;

	   pad=8-length%8;
	   if(pad==8) pad=0;
	   length+=pad;
	 }

	 byte[] mac=calcMac(conn,conn.write_cipher_state,
	   conn.write_sequence_num++,data.value);

	 SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"MAC",mac);
	 
	 byte[] total=new byte[length];

	 System.arraycopy(data.value,0,total,0,data.value.length);
	 System.arraycopy(mac,0,total,data.value.length,mac.length);

	 if(cs.blockCipherP()){
	   for(int i=0;i<(pad+1);i++){
	     total[i+mac.length + data.value.length]=(byte)pad;
	   }
	 }

	 data.value=conn.write_cipher_state.cipher.update(total);
	 SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"Encrypting: cipher text",
	   data.value);
       }
       
       written+=data.encode(conn,s);

       return written;
     }

     //There's a lot of array creation and copying going on here...
     //We may want to tweak this for further efficiency
     public int decode(SSLConn conn,InputStream s)
       throws java.io.IOException,Error {
       int readb=0;
       int length,maclength;
       
       readb=type.decode(conn,s);
       readb+=version.decode(conn,s);
       readb+=data.decode(conn,s);

       if(conn.read_cipher_state != null){
	 byte[] plain;
	 SSLCipherSuite cs;

	 // Just convenience
	 cs=conn.read_cipher_state.cipher_suite;

	 SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"Ciphertext",
	   data.value);
	 
	 if(conn.read_cipher_state.cipher != null){
	   plain=conn.read_cipher_state.cipher.
	     update(data.value);
	 }
	 else{
	   plain=data.value;
	 }

	 SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"Plaintext",
	   plain);
	 
	 if(cs.blockCipherP()){
	   length=plain.length;
	   int pad=(int)plain[length-1];
	   
	   length-=pad + 1;
	 }
	 else{
	   length=plain.length;
	 }

	 maclength=conn.read_cipher_state.cipher_suite.getDigestOutputLength();
	 
	 byte[] tmp=new byte[length-maclength];
	 System.arraycopy(plain,0,tmp,0,tmp.length);

	 
	 byte[] c_mac=calcMac(conn,conn.read_cipher_state,
	   conn.read_sequence_num++,tmp);
	 
	 //We really need a memcmp() equivalent. This sucks
	 byte[] p_mac=new byte[c_mac.length];

	 SSLDebug.debug(SSLDebug.DEBUG_CRYPTO,"MAC",p_mac);

	 
	 System.arraycopy(plain,length-p_mac.length,
	   p_mac,0,p_mac.length);
	 
	 if(!cryptix.util.core.ArrayUtil.areEqual(p_mac,c_mac))
	   conn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
	 
	 length-=p_mac.length;
	 
	 data.value=new byte[length];
	 System.arraycopy(plain,0,data.value,0,length);
       }
       
       return readb;
     }

     // The intermediate step where we pack into a single block isn't
     // strictly necessary, but some SSL implementations choke if
     // the data is weirdly fragmented.
     public void send(SSLConn conn)
       throws Error,java.io.IOException {
       ByteArrayOutputStream tos=new ByteArrayOutputStream();
       
       encode(conn,tos);
       tos.writeTo(conn.sock_out);
       conn.sock_out.flush();
     }

     public byte[] calcMac(SSLConn conn,SSLCipherState st,long sequenceNum,
       byte[] buf){
       return SSLMAC.calcMAC(conn,st,type.value,sequenceNum,buf);
     }
}

