#ifndef PAN_GLOBALS_H
#define PAN_GLOBALS_H

#include "../pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Dump unicode to screen.
 */
/*
void printUnicodeName(char *name, int j)
{
   register int ia;
   for (ia=0;ia<j;ia+=2)
   {
     if (name[ia]!=0) putchar(name[ia]);
     else break;
   }
}*/

/*
 * Dump unicode to string.
 */
void sprintUnicodeName(char *output,char *name, int j)
{
 int ia;
 for (ia=0;ia<j;ia++)
  {
   if (name[ia*2]!=0) output[ia]=name[ia*2];
   else break;
  }
 output[ia]='\0';
} 

void MakeUnicodeName(char *string)
{
 int i;
 for(i=strlen(string)-1;i>0;i--)
  {
   string[i*2]=string[i];
   string[i]=0x00;
  }
}

/********Endian support functions****/
uint32 swap_uint32(uint32 n)
{
    uint8 p[4];
    p[0]=n/0x1000000;
    p[1]=n/0x10000;
    p[2]=n/0x100;
    p[3]=n;
    return (p[0]+p[1]*0x100+p[2]*0x10000+p[3]*0x1000000);
}

uint16 swap_uint16(uint16 n)
{
 uint8 p[2];
 p[0]=n/0x100;
 p[1]=n;
 return (p[0]+p[1]*0x100);
}
/******* End of Endian stuff ********/
/*** char/uint32 converison ***/
uint32 str_to_uint32(uint8 *in)
{uint8 Info[11];
 int i;
 Info[0]='0';Info[1]='x';Info[10]='\0';
 for (i=2;i<10;i++) Info[i]=in[i-2];
 return(strtoul(Info,(char **)NULL,16));
}

uint8 str_to_uint8(char *in)
{
 uint8 Info[5];
 int i;
 Info[0]='0';Info[1]='x';Info[4]='\0';
 for (i=2;i<4;i++) Info[i]=in[i-2];
 return((uint8)(strtoul(Info,(char **)NULL,16)));
}

void uint32_to_str(uint32 in, uint8 *out)
{uint8 Info[9];
 int i;
 sprintf(Info,"%08lx",in);
 for (i=0;i<8;i++) out[i]=Info[i];
}

void str_to_hex(char *in,uint8 *out,int size_string)
{int i;

 memset(out,0,size_string/2);

 for (i=0; i<size_string; i++)
   in[i] = toupper(toascii(in[i]));

 for (i=0;i<size_string;i++)
  {
   if (!in[i]) break;
   if (isdigit((int)in[i])) out[i>>1]=(out[i>>1]<<(4*(i&1)))|((int)in[i]-48);
   else                     out[i>>1]=(out[i>>1]<<(4*(i&1)))|((int)in[i]-55);
  }
}

#ifdef __cplusplus
}
#endif

#endif /* GLOBALS_H */
