/*************************************************************************
 *                                                                       *
 * password.h - header file with extracted passwords file structure.     *
 *************************************************************************/

#ifndef PAN_PASSWORD_H
#define PAN_PASSWORD_H

#include <stdlib.h>
#include "..\pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif


/** API level functions **/
Pan_PassList Pan_PassList_alloc(void)
{
 return (Pan_PassList)calloc(1,sizeof(struct pan_passlist));
}

void Pan_PassList_free(Pan_PassList pPassList)
{
 Pan_PassList p,q;
 for (p=pPassList;p!=0;p=q)
  {q=(p->next);
   free(p);
  }
}

void Pan_PassList_to_PassHack(Pan_PassList pPassList,Pan_PassHack *pPassHack)
{ int i;

  pPassHack->bind=pPassList->bind;
  pPassHack->id=pPassList->id;
  pPassHack->parentID=pPassList->parentID;
  pPassHack->objectID=pPassList->objectID;
  pPassHack->pwlen=pPassList->pwlen;
  for(i=0;i<16;i++) pPassHack->hash[i]=pPassList->hash[i];
  for(i=0;i<40;i++) pPassHack->userOU[i]=pPassList->userOU[i];
  for(i=0;i<258;i++) pPassHack->userCN[i]=pPassList->userCN[i];
}

#ifdef __cplusplus
}
#endif

#endif /* PAN_PASSWORD_H */
